%define        pkgname racc

Name:          gem-%pkgname
Version:       1.5.0
Release:       alt1
Epoch:         1
Summary:       Ruby LALR(1) parser generator
Group:         Development/Ruby
License:       LGPLv2
Url:           http://i.loveruby.net/en/projects/racc/
Vcs:           https://github.com/tenderlove/racc.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
Source:        %name-%version.tar

BuildRequires(pre): rpm-build-ruby
BuildRequires: gem(hoe)
BuildRequires: gem(rake-compiler)

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Obsoletes:     ruby-%pkgname < %EVR
Provides:      ruby-%pkgname = %EVR

%description
Racc is an LALR(1) parser generator.
It is written in ruby itself, and generates ruby programs.

NOTE: Ruby 1.8.x comes with Racc runtime module.
You can run your parsers generated by racc 1.4.x out of the box.

%package       -n %pkgname
Summary:       HTML, XML, SAX, and Reader parser
Group:         Development/Other
BuildArch:     noarch

%description   -n %pkgname
Racc is an LALR(1) parser generator.
It is written in ruby itself, and generates ruby programs.

Executable file for %gemname gem.

%description   -n %pkgname -l ru_RU.UTF8
Исполнямка для %gemname самоцвета.


%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%prep
%setup

%build
%ruby_build --shebang=auto

%install
%ruby_install

%check
%ruby_test

%files
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%files         -n %pkgname
%_bindir/%pkgname

%files         doc
%ruby_gemdocdir


%changelog
