%define        pkgname sassc

Name:          gem-%pkgname
Version:       2.2.1
Release:       alt2.1
Summary:       Use libsass with Ruby!
License:       MIT
Group:         Development/Ruby
Url:           https://github.com/sass/sassc-ruby
Vcs:           https://github.com/sass/sassc-ruby.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
Patch:         patch-2.2.1.patch
BuildRequires(pre): rpm-build-ruby
BuildRequires: gem(bundler)
BuildRequires: gem(rake)
BuildRequires: gem(rake-compiler)
BuildRequires: gem(rake-compiler-dock)
BuildRequires: gem-minitest
BuildRequires: libsass-devel

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Obsoletes:     ruby-%pkgname < %EVR
Provides:      ruby-%pkgname = %EVR
Requires:      libsass

%description
This gem combines the speed of libsass, the Sass C implementation, with
the ease of use of the original Ruby Sass library.


%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%prep
%setup
%patch -p1
# TODO to upstream
sed "s,Dir.entries(libsass_dir).size <= 3,false,"  -i *.gemspec ext/extconf.rb
sed 's/File.expand_path("libsass.#{dl_ext}", __dir__)/"libsass.so"/'  -i lib/sassc/native.rb

%build
%ruby_build

%install
%ruby_install
mkdir -p %buildroot%ruby_gemextdir
# TODO with setup.rb
ln -s $(realpath $(find %_libdir/ -name libsass.so 2>/dev/null)) %buildroot%ruby_gemextdir/libsass.so

%check
%ruby_test

%files
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%files         doc
%ruby_gemdocdir


%changelog
