Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires: rpm-build-java
# END SourceDeps(oneline)
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define version 2.4.0
%global namedreltag %nil
%global namedversion %{version}%{?namedreltag}

Name:          glassfish-hk2
Version:       2.4.0
Release:       alt1_10jpp8
Summary:       Hundred Kilobytes Kernel
License:       CDDL or GPLv2 with exceptions
URL:           http://hk2.java.net/
Source0:       https://github.com/hk2-project/hk2/archive/hk2-parent-%{namedversion}.tar.gz
# https://java.net/jira/browse/HK2-250
# wget -O glassfish-LICENSE.txt https://svn.java.net/svn/glassfish~svn/tags/legal-1.1/src/main/resources/META-INF/LICENSE.txt
# glassfish-hk2 package don't include the license file
Source1:       glassfish-LICENSE.txt
Source2:       hk2-inhabitant-generator-osgi.bundle

# unbundles tiger-types from hk2-utils osgi metadata and
# fixes invalid whitespace in hk2-core osgi metadata
Patch0:        glassfish-hk2-2.3.0-hk2-utils-osgi_bundle.patch

BuildRequires: maven-local
BuildRequires: mvn(aopalliance:aopalliance)
BuildRequires: mvn(args4j:args4j)
BuildRequires: mvn(com.google.inject:guice)
BuildRequires: mvn(com.sun.codemodel:codemodel)
BuildRequires: mvn(javax.el:javax.el-api)
BuildRequires: mvn(javax.enterprise:cdi-api)
BuildRequires: mvn(javax.inject:javax.inject)
BuildRequires: mvn(junit:junit)
BuildRequires: mvn(net.java:jvnet-parent:pom:)
BuildRequires: mvn(org.apache.ant:ant)
BuildRequires: mvn(org.apache.ant:ant-launcher)
BuildRequires: mvn(org.apache.bcel:bcel)
BuildRequires: mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires: mvn(org.apache.felix:org.apache.felix.bundlerepository)
BuildRequires: mvn(org.apache.felix:org.osgi.core)
BuildRequires: mvn(org.apache.maven:maven-archiver)
BuildRequires: mvn(org.apache.maven:maven-artifact)
BuildRequires: mvn(org.apache.maven:maven-compat)
BuildRequires: mvn(org.apache.maven:maven-core)
BuildRequires: mvn(org.apache.maven:maven-plugin-api)
BuildRequires: mvn(org.apache.maven.plugins:maven-antrun-plugin)
BuildRequires: mvn(org.apache.maven.plugins:maven-compiler-plugin)
BuildRequires: mvn(org.apache.maven.plugins:maven-enforcer-plugin)
BuildRequires: mvn(org.apache.maven.plugins:maven-plugin-plugin)
BuildRequires: mvn(org.apache.maven.shared:maven-osgi)
BuildRequires: mvn(org.easymock:easymock)
BuildRequires: mvn(org.hibernate:hibernate-validator)
BuildRequires: mvn(org.javassist:javassist)
BuildRequires: mvn(org.jvnet:tiger-types)
BuildRequires: mvn(org.mockito:mockito-core)
BuildRequires: mvn(org.osgi:org.osgi.compendium)
BuildRequires: mvn(org.osgi:org.osgi.core)
BuildRequires: mvn(org.ow2.asm:asm-all)
BuildRequires: mvn(org.springframework:spring-context)
BuildRequires: mvn(org.testng:testng)

Obsoletes:     %{name}-apt

BuildArch:     noarch
Source44: import.info

%description
HK2 for Hundred Kilobytes Kernel is an abstraction to
a module subsystem coupled with a simple yet powerful
component model to build server side software.

%package api
Group: Development/Java
Summary:       HK2 API module

%description api
Hundred Kilobytes Kernel API module.

%package class-model
Group: Development/Java
Summary:       Class Model for Hk2

%description class-model
Hundred Kilobytes Kernel Class Model.

%package configuration
Group: Development/Java
Summary:       HK2 configuration modules

%description configuration
Hundred Kilobytes Kernel configuration modules.

%package core
Group: Development/Java
Summary:       HK2 core module

%description core
Hundred Kilobytes Kernel core module.

%package dependency-verifier
Group: Development/Java
Summary:       HK2 Static Analyser for verifying module dependency

%description dependency-verifier
HK2 Static Analyser for verifying module dependency.

%package dependency-visualizer
Group: Development/Java
Summary:       HK2 Tool to visualize the dependencies

%description dependency-visualizer
Tool to visualize the dependencies generated by
HK2's dependency-verifier.

%package extras
Group: Development/Java
Summary:       HK2 extras module

%description extras
Default implementations for HK2 services.

%package guice-bridge
Group: Development/Java
Summary:       HK2 Guice Bridge

%description guice-bridge
Hundred Kilobytes Kernel Guice Bridge.

%package hk2
Group: Development/Java
Summary:       HK2 module of HK2 itself

%description hk2
This is so that other modules can depend on HK2 as an HK2 module.

%package inhabitant-generator
Group: Development/Java
Summary:       HK2 Inhabitant Generator - maven plugin

%description inhabitant-generator
Hundred Kilobytes Kernel Inhabitant Generator - maven plugin.

%package jmx
Group: Development/Java
Summary:       HK2 JMX module

%description jmx
Hundred Kilobytes Kernel JMX module.

%package locator
Group: Development/Java
Summary:       HK2 ServiceLocator Default Implementation

%description locator
Hundred Kilobytes Kernel ServiceLocator Default Implementation.

%package locator-extras
Group: Development/Java
Summary:       HK2 Locator unit tests

%description locator-extras
Extra unit tests for the HK2 Locator implementation.

%package locator-no-proxies
Group: Development/Java
Summary:       HK2 Locator No Proxy Unit tests

%description locator-no-proxies
Tests the basic HK2 locator with no proxiable scopes.

%package locator-no-proxies2
Group: Development/Java
Summary:       HK2 Locator No Proxy Unit tests (2)

%description locator-no-proxies2
Tests the basic HK2 locator using AOP proxies.

%package maven
Group: Development/Java
Summary:       HK2 Module system maven support

%description maven
HK2 Maven plugin for developing.

%package maven-plugins
Group: Development/Java
Summary:       HK2 Maven Plugins

%description maven-plugins
This package provides:
* consolidated bundle Maven plugin,
* osgiversion-maven-plugin - Maven Plugin for
computing OSGi versions from Maven versions.

%package metadata-generator
Group: Development/Java
Summary:       HK2 Metadata Generator

%description metadata-generator
HK2 Metadata Generator Subsystem.

%package osgi
Group: Development/Java
Summary:       HK2 OSGi Adapter

%description osgi
HK2 Maven plugin for developing.

%package osgi-resource-locator
Group: Development/Java
Summary:       HK2 OSGi resource locator bundle
Obsoletes:     osgi-resource-locator < %{version}-%{release}
Provides:      osgi-resource-locator = %{version}-%{release}

%description osgi-resource-locator
Hundred Kilobytes Kernel - OSGi resource locator bundle. Used by
various API providers that rely on META-INF/services mechanism to
locate providers.

%package runlevel
Group: Development/Java
Summary:       HK2 Run Level Service

%description runlevel
Hundred Kilobytes Kernel Run Level Service.

%package spring-bridge
Group: Development/Java
Summary:       HK2 Spring Bridge

%description spring-bridge
Hundred Kilobytes Kernel Spring Bridge.

%package runlevel-extras
Group: Development/Java
Summary:    HK2 RunLevel unit tests

%description runlevel-extras
Extra unit tests for the HK2 RunLevelService implementation.

%package testing
Group: Development/Java
Summary:       Utilities for testing with HK2

%description testing
Hundred Kilobytes Kernel Utilities for testing.

%package testng
Group: Development/Java
Summary:      HK2 TestNG runner

%description testng
A utility for running HK2 under TestNG.

%package utils
Group: Development/Java
Summary:       HK2 Implementation Utilities

%description utils
Hundred Kilobytes Kernel Implementation Utilities.

%package javadoc
Group: Development/Java
Summary:       Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains javadoc for %{name}.

%prep
%setup -q -n hk2-hk2-parent-%{namedversion}
# Do not remove test resources
find . -name '*.jar' ! -name "gendir.jar" -type f -print -delete
find . -name '*.class' -print -delete

%patch0 -p0
# Use system libraries
%pom_change_dep -r org.glassfish.hk2.external:asm-all-repackaged org.ow2.asm:asm-all:'${asm.version}'
%pom_change_dep -r org.glassfish.hk2.external:aopalliance-repackaged aopalliance:aopalliance:'${aopalliance.version}'
%pom_change_dep -r org.glassfish.hk2.external:javax.inject javax.inject::'${javax-inject.version}'
%pom_change_dep -r org.glassfish.hk2.external:bean-validator org.hibernate:hibernate-validator:'${hibernate-validator.version}'
%pom_change_dep -r org.glassfish.hk2.external:bean-validator-cdi org.hibernate:hibernate-validator-cdi:'${hibernate-validator.version}'
%pom_change_dep -r org.glassfish.hk2:tiger-types-osgi org.jvnet:tiger-types:'${tiger-types.version}'
# class-model hk2-inhabitant-generator hk2-testing/hk2-junitrunner
find ./ -name "*.java" -exec sed -i "s/org.glassfish.hk2.external.org.objectweb.asm/org.objectweb.asm/g" {} +
# hk2-api hk2-extras
%pom_change_dep -r :osgi-resource-locator ::'${project.version}'

%pom_remove_plugin :maven-resources-plugin
# org.apache.maven.wagon:wagon-webdav-jackrabbit:2.0
%pom_xpath_remove pom:build/pom:extensions

%pom_remove_plugin com.googlecode.maven-download-plugin:maven-download-plugin
%pom_remove_plugin :maven-site-plugin
%pom_remove_plugin :maven-eclipse-plugin
%pom_remove_plugin :findbugs-maven-plugin
%pom_remove_plugin -r :jacoco-maven-plugin
%pom_remove_dep -r :jacoco-maven-plugin

%pom_disable_module external
%pom_disable_module examples
# Use unavailable: org.ops4j.pax.exam, org.ops4j.pax.url
%pom_disable_module osgi-adapter-test osgi/adapter-tests
%pom_remove_dep :osgi-adapter-test bom

%pom_remove_dep org.ops4j.base:
%pom_remove_dep org.ops4j.pax.exam:
%pom_remove_dep org.ops4j.pax.tipi:
%pom_remove_dep org.ops4j.pax.url:

%pom_remove_dep -r org.apache.geronimo.specs:geronimo-atinject_1.0_spec
%pom_remove_dep org.junit:com.springsource.org.junit
%pom_remove_dep org.osgi:osgi_R4_core

# disable tiger-types copy
%pom_remove_plugin :maven-dependency-plugin hk2-utils
%pom_remove_plugin :maven-dependency-plugin osgi/adapter-tests/sdp-management-bundle

%pom_xpath_remove "pom:plugin[pom:artifactId ='maven-surefire-plugin']/pom:configuration" hk2-api
%pom_xpath_remove "pom:plugin[pom:artifactId ='maven-surefire-plugin']/pom:configuration" hk2-locator


%pom_xpath_set "pom:dependency[pom:groupId ='org.osgi']/pom:artifactId" org.osgi.core hk2-maven

%pom_change_dep -r :maven-project :maven-core
%pom_add_dep org.apache.maven:maven-compat hk2-maven

%pom_change_dep :org.osgi.enterprise org.osgi:org.osgi.compendium:4.2.0 class-model

%pom_xpath_set "pom:dependency[pom:groupId ='com.sun']/pom:artifactId" tools hk2-testing/ant
%pom_xpath_remove "pom:dependency[pom:groupId ='com.sun']/pom:scope" hk2-testing/ant
%pom_xpath_remove "pom:dependency[pom:groupId ='com.sun']/pom:systemPath" hk2-testing/ant
%pom_xpath_remove "pom:profiles/pom:profile[pom:id ='mac']" hk2-testing/ant

# Unavailable test dep org.assertj:assertj-core:1.4.0 org.uncommons:reportng:jar:1.1.2
%pom_remove_dep -r org.assertj:assertj-core
%pom_remove_dep -r org.uncommons:reportng
rm -r hk2-testing/hk2-testng/src/test/java/*
rm -r hk2-testing/hk2-mockito/src/test/java/*
rm -r hk2-testing/hk2-runlevel-extras/src/test/java/*

%pom_change_dep -r ant:ant org.apache.ant:ant

%pom_xpath_set "pom:addClasspath" false dependency-verifier

mkdir -p hk2/target/classes
%pom_remove_plugin :maven-jar-plugin hk2

# Drop pre-existent OSGI manifest file
rm -r hk2-inhabitant-generator/src/main/resources/META-INF/MANIFEST.MF
%pom_add_plugin org.apache.felix:maven-bundle-plugin:2.3.7 hk2-inhabitant-generator '
<configuration>
  <supportedProjectTypes>
   <supportedProjectType>maven-plugin</supportedProjectType>
  </supportedProjectTypes> 
</configuration>
<executions>
  <execution>
    <id>bundle-manifest</id>
    <phase>process-classes</phase>
    <goals>
      <goal>manifest</goal>
    </goals>
  </execution>
</executions>'

# Add configuration file for osgiversion plugin
cp -p %SOURCE2 hk2-inhabitant-generator/osgi.bundle
%pom_add_plugin org.glassfish.hk2:osgiversion-maven-plugin:'${project.version}' hk2-inhabitant-generator

# Inject manifest file
%pom_add_plugin org.apache.maven.plugins:maven-jar-plugin:2.4 hk2-inhabitant-generator "
<configuration>
  <manifestFile>\${project.build.outputDirectory}/META-INF/MANIFEST.MF</manifestFile>
  <archive>
    <manifestEntries>
      <service>foo</service>
    </manifestEntries>
  </archive>
</configuration>"

# fix build failure. 'useDefaultManifestFile' has been removed from the maven-jar-plugin >= 3.0.0
%pom_xpath_remove "pom:plugin[pom:artifactId = 'maven-jar-plugin']/pom:configuration/pom:useDefaultManifestFile"
%pom_xpath_inject "pom:plugin[pom:artifactId = 'maven-jar-plugin']/pom:configuration" "
  <manifestFile>\${project.build.outputDirectory}/META-INF/MANIFEST.MF</manifestFile>"
%pom_xpath_remove "pom:plugin[pom:artifactId = 'maven-bundle-plugin']/pom:configuration"
%pom_xpath_inject "pom:plugin[pom:artifactId = 'maven-bundle-plugin']" "
<extensions>true</extensions>
<executions>
  <execution>
    <id>bundle-manifest</id>
    <phase>process-classes</phase>
    <goals>
      <goal>manifest</goal>
    </goals>
  </execution>
</executions>"
%pom_remove_plugin :maven-jar-plugin osgi-resource-locator
%pom_xpath_remove "pom:plugin[pom:artifactId = 'maven-jar-plugin']/pom:configuration/pom:useDefaultManifestFile" hk2-utils
%pom_xpath_inject "pom:plugin[pom:artifactId = 'maven-jar-plugin']/pom:configuration" "
  <manifestFile>\${project.build.outputDirectory}/META-INF/MANIFEST.MF</manifestFile>" hk2-utils
for m in class-model \
 guice-bridge \
 hk2 \
 hk2-api \
 hk2-configuration/hk2-integration \
 hk2-configuration/manager \
 hk2-configuration/persistence/hk2-xml/main \
 hk2-configuration/persistence/hk2-xml/test1 \
 hk2-configuration/persistence/hk2-xml-dom/config-types \
 hk2-configuration/persistence/hk2-xml-dom/hk2-config \
 hk2-configuration/persistence/hk2-xml-dom/hub-integration \
 hk2-configuration/persistence/property-file \
 hk2-core \
 hk2-extras \
 hk2-jmx \
 hk2-locator \
 hk2-runlevel \
 hk2-testing/collections \
 hk2-testing/hk2-junitrunner \
 hk2-testing/hk2-locator-extras \
 hk2-testing/hk2-locator-no-proxies \
 hk2-testing/hk2-locator-no-proxies2 \
 hk2-utils \
 osgi/adapter \
 osgi/adapter-tests/faux-sdp-bundle \
 osgi/adapter-tests/sdp-management-bundle \
 osgi-resource-locator \
 spring-bridge
do
 %pom_xpath_inject "pom:project" "<packaging>bundle</packaging>" ${m}
 %pom_xpath_inject "pom:plugin[pom:artifactId = 'maven-bundle-plugin']" "<extensions>true</extensions>" ${m}
done
for m in osgi/adapter-tests/contract-bundle \
 osgi/adapter-tests/no-hk2-bundle \
 osgi/adapter-tests/test-module-startup
do
 %pom_xpath_set "pom:project/pom:packaging" bundle ${m}
 %pom_xpath_inject "pom:plugin[pom:artifactId = 'maven-bundle-plugin']" "<extensions>true</extensions>" ${m}
done

# use bnd instructions contained in osgi.bundle files
%pom_xpath_remove "pom:plugin[pom:artifactId = 'maven-bundle-plugin']/pom:configuration" hk2-utils
for m in $(find -name osgi.bundle -exec dirname {} \;)
do
 # fix comments in bnd instruction files that are unacceptible for strict new bnd version
 sed -i -e 's/^[ /]\*/# /' $m/osgi.bundle
 # insert include instruction into maven-bundle-plugin configuration section
 if [ "$(basename $m)" = "hk2-inhabitant-generator" ] ; then
  %pom_xpath_inject "pom:plugin[pom:artifactId = 'maven-bundle-plugin']/pom:configuration" "<instructions><_include>osgi.bundle</_include></instructions>" ${m}
 else
  %pom_xpath_inject "pom:plugin[pom:artifactId = 'maven-bundle-plugin']" "<configuration><instructions><_include>osgi.bundle</_include></instructions></configuration>" ${m}
 fi
done

cp -p %{SOURCE1} LICENSE.txt
sed -i 's/\r//' LICENSE.txt

%mvn_package ":class-model" class-model
%mvn_package ":hk2" hk2
%mvn_package ":hk2-api" api
%mvn_package ":hk2-bom" %{name}
%mvn_package ":hk2-core" core
%mvn_package ":hk2-parent" %{name}
%mvn_package ":config-generator" configuration
%mvn_package ":config-types" configuration
%mvn_package ":hk2-config" configuration
%mvn_package ":hk2-config-hub-integration" configuration
%mvn_package ":hk2-configuration" configuration
%mvn_package ":hk2-configuration-integration" configuration
%mvn_package ":hk2-configuration-hub" configuration
%mvn_package ":hk2-configuration-persistence" configuration
%mvn_package ":hk2-property-file" configuration
%mvn_package ":hk2-xml-parent" configuration
%mvn_package ":hk2-xml" configuration
%mvn_package ":hk2-xml-test" configuration
%mvn_package ":hk2-xml-dom" configuration
%mvn_package ":hk2-dependency-verifier" dependency-verifier
%mvn_package ":hk2-dependency-visualizer" dependency-visualizer
%mvn_package ":hk2-extras" extras
%mvn_package ":hk2-inhabitant-generator" inhabitant-generator
%mvn_package ":hk2-jmx" jmx
%mvn_package ":hk2-locator" locator
%mvn_package ":hk2-locator-extras" locator-extras
%mvn_package ":hk2-locator-no-proxies" locator-no-proxies
%mvn_package ":hk2-locator-no-proxies2" locator-no-proxies2
%mvn_package ":hk2-maven" maven
%mvn_package ":consolidatedbundle-maven-plugin" maven-plugins
%mvn_package ":osgiversion-maven-plugin" maven-plugins
%mvn_package ":hk2-metadata-generator-parent" metadata-generator
%mvn_package ":hk2-metadata-generator" metadata-generator
%mvn_package ":hk2-metadata-generator-test1" metadata-generator
%mvn_package ":hk2-runlevel" runlevel
%mvn_package ":hk2-runlevel-extras" runlevel-extras
%mvn_package ":hk2-utils" utils
%mvn_package ":guice-bridge" guice-bridge
%mvn_package ":spring-bridge" spring-bridge
%mvn_package ":hk2-testing" testing
%mvn_package ":hk2-junitrunner" testing
%mvn_package ":hk2-ant-test" testing
%mvn_package ":hk2-collections-tests" testing
%mvn_package ":hk2-mockito" testing
%mvn_package ":interceptor-events" testing
%mvn_package ":hk2-testng" testng
%mvn_package ":osgi" osgi
%mvn_package ":osgi-adapter" osgi
%mvn_package ":osgi-adapter-tests-parent" osgi
%mvn_package ":contract-bundle" osgi
%mvn_package ":faux-sdp-bundle" osgi
%mvn_package ":no-hk2-bundle" osgi
%mvn_package ":sdp-management-bundle" osgi
%mvn_package ":test-module-startup" osgi
%mvn_package ":osgi-resource-locator" osgi-resource-locator

%build

%mvn_build -- -Dmaven.test.failure.ignore=true -DsurefireArgLineExtra="-enableassertions"

%install
%mvn_install

%files -f .mfiles-%{name}
%doc README.md
%doc --no-dereference LICENSE.txt

%files api -f .mfiles-api
%doc --no-dereference LICENSE.txt

%files class-model -f .mfiles-class-model
%doc --no-dereference LICENSE.txt

%files configuration -f .mfiles-configuration
%doc --no-dereference LICENSE.txt

%files core -f .mfiles-core
%doc --no-dereference LICENSE.txt

%files dependency-verifier -f .mfiles-dependency-verifier
%doc --no-dereference LICENSE.txt

%files dependency-visualizer -f .mfiles-dependency-visualizer
%doc dependency-visualizer/README
%doc --no-dereference LICENSE.txt

%files extras -f .mfiles-extras
%doc --no-dereference LICENSE.txt

%files guice-bridge -f .mfiles-guice-bridge
%doc --no-dereference LICENSE.txt

%files hk2 -f .mfiles-hk2
%doc --no-dereference LICENSE.txt

%files inhabitant-generator -f .mfiles-inhabitant-generator
%doc --no-dereference LICENSE.txt

%files jmx -f .mfiles-jmx
%doc --no-dereference LICENSE.txt

%files locator -f .mfiles-locator
%doc --no-dereference LICENSE.txt

%files locator-extras -f .mfiles-locator-extras
%doc hk2-testing/hk2-locator-extras/README.txt
%doc --no-dereference LICENSE.txt

%files locator-no-proxies -f .mfiles-locator-no-proxies
%doc hk2-testing/hk2-locator-no-proxies/README.txt
%doc --no-dereference LICENSE.txt

%files locator-no-proxies2 -f .mfiles-locator-no-proxies2
%doc hk2-testing/hk2-locator-no-proxies2/README.txt
%doc --no-dereference LICENSE.txt

%files maven -f .mfiles-maven
%doc --no-dereference LICENSE.txt

%files maven-plugins -f .mfiles-maven-plugins
%doc --no-dereference LICENSE.txt

%files metadata-generator -f .mfiles-metadata-generator
%doc --no-dereference LICENSE.txt

%files osgi -f .mfiles-osgi
%doc --no-dereference LICENSE.txt

%files osgi-resource-locator -f .mfiles-osgi-resource-locator
%doc --no-dereference LICENSE.txt

%files runlevel -f .mfiles-runlevel
%doc --no-dereference LICENSE.txt

%files runlevel-extras -f .mfiles-runlevel-extras
%doc hk2-testing/hk2-runlevel-extras/README.txt
%doc --no-dereference LICENSE.txt

%files spring-bridge -f .mfiles-spring-bridge
%doc --no-dereference LICENSE.txt

%files testing -f .mfiles-testing
%doc --no-dereference LICENSE.txt

%files testng -f .mfiles-testng
%doc hk2-testing/hk2-testng/README.md
%doc --no-dereference LICENSE.txt

%files utils -f .mfiles-utils
%doc --no-dereference LICENSE.txt

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE.txt

%changelog
