Name: gri
Summary: A language for scientific illustration
Version: 2.12.23
Release: alt5
Group: Development/Tools
License: GPL v2
URL: http://gri.sourceforge.net

Source: %name-%version.tar.gz
Source1: http://gri.sourceforge.net/refcard.pdf
Source2: http://gri.sourceforge.net/cmdrefcard.pdf
Source3: http://gri.sourceforge.net/gri.pdf
Patch1: %name-%version-debian-texi.patch
Patch2: %name-%version-alt-perl-compat.patch
Patch3: %name-%version-alt-gcc7-compat.patch

BuildRequires: gcc-c++ ImageMagick-tools texlive-base-bin info
BuildRequires: ghostscript-classic perl4-compat
BuildRequires: makeinfo

%description
Gri is a language for scientific graphics programming.  It is a
command-driven application, as opposed to a click/point application.
It is analogous to latex, and shares the property that extensive power
is the reward for tolerating a modest learning curve.  Gri output is
in industry-standard PostScript, suitable for incorporation in
documents prepared by various text processors.

Gri can make x-y graphs, contour-graphs, and image graphs.  In
addition to high-level capabilities, it has enough low-level
capabilities to allow users to achieve a high degree of customization.
Precise control is extended to all aspects of drawing, including
line-widths, colors, and fonts.  Text includes a subset of the tex
language, so that it is easy to incorporate Greek letters and
mathematical symbols in labels.

The following is a terse yet working Gri program.  If it is stored in
a file called 'example.gri', and executed with the unix command 'gri
example', it will create a postscript file called 'example.ps' with
a linegraph connecting data points in the file called `file.dat'.

   open file.dat        # open a file with columnar data
   read columns x * y   # read first column as x and third as y
   draw curve           # draw line through data (autoscaled axes)

%package doc
Summary: Documentation for Gri
Group: Documentation
BuildArch: noarch

%description doc
Gri is a language for scientific graphics programming.  It is a
command-driven application, as opposed to a click/point application.
It is analogous to latex, and shares the property that extensive power
is the reward for tolerating a modest learning curve.  Gri output is
in industry-standard PostScript, suitable for incorporation in
documents prepared by various text processors.

This package contains documentation for Gri.

%prep
%setup
%patch1 -p1
%patch2 -p2
%patch3 -p2

%build
%autoreconf
%configure --enable-linux_redhat
%make_build

%install
%makeinstall_std

mv %buildroot%_docdir/%name-%version %buildroot%_docdir/%name
install -p -m644 %SOURCE1 %SOURCE2 %SOURCE3 %buildroot%_docdir/%name

%files
%doc AUTHORS COPYING ChangeLog NEWS README THANKS license.txt copyright.txt
%_bindir/*
%_datadir/%name
%_man1dir/*
%_infodir/*
%_emacslispdir/*

%files doc
%_docdir/%name

%changelog
