# #%define svn git20170409

Name: handbrake
Version: 1.3.1
Release: alt3
Summary: Multithreaded Video Transcoder
Packager: Motsyo Gennadi <drool@altlinux.ru>
Source0: HandBrake-%version.tar.bz2
# #Source0: %name-%svn.tar.bz2

Source101: https://download.handbrake.fr/contrib/libvpx-1.7.0.tar.gz
Source102: https://github.com/FFmpeg/nv-codec-headers/releases/download/n9.0.18.1/nv-codec-headers-9.0.18.1.tar.gz
Source103: https://download.handbrake.fr/handbrake/contrib/libav-12.3.tar.gz
Source104: https://download.videolan.org/pub/videolan/libdvdread/6.0.2/libdvdread-6.0.2.tar.bz2
Source105: https://download.videolan.org/pub/videolan/libdvdnav/6.0.1/libdvdnav-6.0.1.tar.bz2
Source106: https://download.videolan.org/pub/videolan/x265/x265_3.2.1.tar.gz
Source107: https://download.handbrake.fr/handbrake/contrib/ffmpeg-4.2.2.tar.bz2
Source108: https://download.videolan.org/pub/videolan/libbluray/1.1.2/libbluray-1.1.2.tar.bz2
Source109: https://download.handbrake.fr/handbrake/contrib/fdk-aac-2.0.1.tar.gz
Source110: https://code.videolan.org/videolan/dav1d/-/archive/0.5.1/dav1d-0.5.1.tar.bz2

Source200: x265-x32.patch

Url: http://handbrake.fr/
Group: Video
License: GPLv2+

BuildRequires: bzlib-devel doxygen gcc-c++ intltool libass-devel libdbus-glib-devel libfribidi-devel libglademm-devel libgtk+3-devel
BuildRequires: libharfbuzz-devel libjansson-devel liblame-devel libnotify-devel libopus-devel libsamplerate-devel libssl-devel libtheora-devel
BuildRequires: libvorbis-devel libx264-devel libxml2-devel python-modules-json cmake libspeex-devel liblzma-devel libnuma-devel libvpx5-devel
BuildRequires: nasm meson

ExclusiveArch: x86_64

%description
HandBrake is an open-source, GPL-licensed, multiplatform, multithreaded video
transcoder.

%package cli
Summary: Multithreaded Video Transcoder
Group: Video

%description cli
HandBrake is an open-source, GPL-licensed, multiplatform, multithreaded video
transcoder.

This package contains a command-line interface for Handbrake.

%package gtk
Summary: Multithreaded Video Transcoder
Group: Video
Requires: %name-cli = %version-%release

%description gtk
HandBrake is an open-source, GPL-licensed, multiplatform, multithreaded video
transcoder.

This package contains a GTK+ graphical user interface for Handbrake.

%prep
%setup -n HandBrake-%version
# #%setup -n %name-svn

# Copy 3rd party dependencies into expected locations:
%__mkdir download
for f in \
%{S:101} %{S:102} %{S:103} %{S:104} %{S:105} %{S:106} \
%{S:107} %{S:108} %{S:109} %{S:110} \
; do
     %__ln_s "$f" download/
done

%build
export CFLAGS="%optflags"
export CXXFLAGS="%optflags"

%__cp "%{S:200}" contrib/x265/A99-x265-x32.patch
%__cp "%{S:200}" contrib/x265_8bit/A99-x265-x32.patch
%__cp "%{S:200}" contrib/x265_10bit/A99-x265-x32.patch
%__cp "%{S:200}" contrib/x265_12bit/A99-x265-x32.patch

./configure	--prefix="%buildroot%prefix" \
		--snapshot \
		--disable-gtk-update-checks \
		--enable-fdk-aac
pushd build
%__make build
popd

%install
pushd build
%__make install
popd

%__ln_s ghb "%buildroot%_bindir/HandBrakeGUI"

%__rm "%buildroot%_datadir/icons"/*/*.cache

%find_lang --with-gnome ghb

%files cli
%doc AUTHORS.markdown COPYING LICENSE NEWS.markdown README.markdown THANKS.markdown
%_bindir/HandBrakeCLI

%files gtk -f ghb.lang
%_bindir/HandBrakeGUI
%_bindir/ghb
%_desktopdir/*.desktop
%_datadir/icons/*/*/apps/*.svg
%_datadir/metainfo/*.xml

%changelog
