%define dname jabberd-jit
%define username _jabber_jit

Name: jabber-jit

Version: 1.2.1
Release: alt0.5

Summary: Jabber ICQ Transport

Group: System/Servers
License: %gpl2plus
URL: http://omever.ya.ru/
#SVN URL: svn://ns1.mytlt.ru/jit/
Packager: Nikolay A. Fetisov <naf@altlinux.ru>

Source: jit-%version.tar
Source1: %name.xml
Source2: %name.logrotate
Source3: %name.init
Source4: %name.adapter

Patch1:  %name-1.1.5-no-thanks-we-have-logrotate.patch
Patch2:  %name-1.2.1-alt-headers_fix.patch
Patch3:  %name-1.2.1-alt-time_header.patch
Patch4:  %name-1.2.1-alt-istream.patch

Obsoletes: ejabberd-jit
#Requires(post): jabber-common
Requires(post): rpm-macros-jabber

BuildRequires(pre): rpm-build-licenses jabber-common
# Automatically added by buildreq on Mon Jan 23 2017
# optimized out: libstdc++-devel python-base python-modules python3
BuildRequires: gcc-c++ libmhash-devel python-module-distribute python-module-google python3-base ruby ruby-stdlibs

%description
Jabber ICQ Transport is a Jabber component which provides interoperability
between ICQ and Jabber IM systems. JIT is based on a special fast jabberd
core with pthreads.

%prep
%setup -q -n jit-%version
%patch1 -p1

%patch2
%patch3
%patch4

pushd jit/jit
../../makeversion.sh
popd

%build
subst '/^COMMON_CFLAGS/ s|-I%_includedir ||' platform-settings
subst 's|^OUT_FILE=.*|OUT_FILE=jabber-jit|' platform-settings
subst '/^COMMON_CFLAGS/ s|-g ||' platform-settings
subst '/^CONFIG_FILE/ s|jabber.xml|jabber-jit.xml|' platform-settings

%configure
%make_build

%install
mkdir -p %buildroot%_sbindir \
    %buildroot%_libdir/%name \
    %buildroot%_sysconfdir/%name \
    %buildroot%_spooldir/%name \
    %buildroot%_initdir \
    %buildroot%_docdir/%name-%version \
    %buildroot%_sysconfdir/logrotate.d

/bin/install jabberd/jabberd-jit %buildroot%_sbindir/jabber-jit
/bin/install jit/jit.so %buildroot%_libdir/%name
/bin/install xdb_file/xdb_file.so %buildroot%_libdir/%name

/bin/install {README,AUTHORS} %buildroot%_docdir/%name-%version
/bin/install -m644 LICENSE %buildroot%_docdir/%name-%version
/bin/install doc/FAQ %buildroot%_docdir/%name-%version
/bin/install jit/{INSTALL,*.example} %buildroot%_docdir/%name-%version
/bin/install -m644 ChangeLog %buildroot%_docdir/%name-%version

/bin/install -m640 %SOURCE1 %buildroot%_sysconfdir/%name/%name.xml
/bin/install -m644 %SOURCE2 %buildroot%_sysconfdir/logrotate.d/%name
/bin/install -m755 %SOURCE3 %buildroot%_initdir/%name
/bin/install -pD -m0755 %SOURCE4 %buildroot%_jabber_component_dir/%name

subst 's#@libdir@#%_libdir/%{name}#g' %buildroot%_initdir/%name \
		%buildroot%_sysconfdir/%name/%name.xml
subst 's#@configfile@#%_sysconfdir/%name/%name.xml#g' %buildroot%_jabber_component_dir/%name


%pre
%_sbindir/groupadd -r -f %username 2>/dev/null ||:
%_sbindir/useradd -r -g %username -c 'jabber transport' -d %_datadir/%name \
 -s /dev/null %username 2>/dev/null ||:

%post
%_jabber_config
%post_service %name

%preun
%preun_service %name

%files
%_sbindir/%name
%_libdir/%name
%config(noreplace) %attr(0640,root,%username) %_sysconfdir/%name/%name.xml
%dir %attr(1770,root,%username) %_spooldir/%name
%_initdir/%name
%_docdir/%name-%version
%_sysconfdir/logrotate.d/%name
%_jabber_component_dir/%name

%changelog
