%define ver_major 4.2
%define _name cjs
%define api_ver 1.0

Name: lib%_name
Version: %ver_major.0
Release: alt1

Summary: Javascript Bindings for Cinnamon
Group: System/Libraries
# The following files contain code from Mozilla which
# is triple licensed under MPL1.1/LGPLv2+/GPLv2+:
# The console module (modules/console.c)
# Stack printer (cjs/stack.c)
License: MIT and (MPLv1.1 or GPLv2+ or LGPLv2+)
Url: https://github.com/linuxmint/cjs

Source: %_name-%version.tar
Source1: pkg.m4
Patch: %_name-%version-%release.patch

%define glib_ver 2.33.14
%define gi_ver 1.33.14

BuildRequires: gcc-c++ libcairo-devel
BuildRequires: glib2-devel >= %glib_ver gobject-introspection-devel >= %gi_ver
BuildRequires: libdbus-glib-devel libreadline-devel libcairo-gobject-devel
BuildRequires: gnome-common
BuildRequires: libmozjs52-devel

# for check
BuildRequires: /proc dbus-tools-gui

%description
Cjs allows using GNOME/Cinnamon libraries from Javascript. It's based on the
Spidermonkey Javascript engine from Mozilla and the GObject introspection
framework.

%package devel
Summary: Development package for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
Files for development with %name.

%set_typelibdir %_libdir/%_name/girepository-1.0


%prep
%setup -q -n %_name-%version
[ ! -d m4 ] && mkdir m4
cp %SOURCE1 m4/
%patch0 -p1

%build
%autoreconf
%configure \
    --disable-static

%make_build

%install
%make DESTDIR=%buildroot install

#%check
#%make check

%files
%_bindir/%_name
%_bindir/%_name-console
%_libdir/*.so.*
%dir %_libdir/%_name/
%dir %_libdir/%_name/girepository-1.0
%_libdir/%_name/girepository-1.0/CjsPrivate-%api_ver.typelib
%doc COPYING NEWS README

%files devel
%_includedir/%_name-%api_ver/
%_libdir/*.so
%_libdir/pkgconfig/%_name-%api_ver.pc

%doc examples/*

%changelog
