%define _name libgee
%define ver_major 0.20
%define api_ver 0.8
%def_disable static

Name: %_name%api_ver
Version: %ver_major.2
Release: alt1

Summary: a collection library providing GObject-based interfaces
License: LGPL
Group: System/Libraries
Url: http://live.gnome.org/Libgee

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

BuildRequires: libgio-devel >= 2.36 gobject-introspection-devel
BuildRequires: libvala-devel >= 0.23.2 vala-tools

%description
libgee is a collection library providing GObject-based interfaces and classes
for commonly used data structures.

The ArrayList, HashSet, and HashMap classes provide a reasonable sample
implementation of the List, Set, and Map interfaces. ReadOnlyCollection,
ReadOnlyList, ReadOnlySet, and ReadOnlyMap are read-only wrapper classes that
prevent modification of the underlying collection.

libgee is written in Vala and can be used like any GObject-based C
library. It's planned to provide bindings for further languages.

%package devel
Group: Development/C
Summary: Development files of %name
Provides: %_name-devel = %version-%release
Requires: %name = %version-%release

%description devel
libgee is a collection library providing GObject-based interfaces and classes
for commonly used data structures.

This package contains the C headers and libs required for building programs
with %name.

%package gir
Summary: GObject introspection data for the libgee library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the libgee library

%package gir-devel
Summary: GObject introspection devel data for the libgee library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for the libgee library

%if_enabled static
%package devel-static
Group: Development/C
Summary: Static library of %name
Requires: %name-devel = %version-%release

%description devel-static
libgee is a collection library providing GObject-based interfaces and classes
for commonly used data structures.

This package contains the static library required for statically linking
applications with %name.

%endif #enabled static

%prep
%setup -n %_name-%version

%build
%autoreconf
%configure %{subst_enable static}
%make_build

%install
%makeinstall_std

%check
%make check

%files
%_libdir/libgee-%api_ver.so.*
%doc AUTHORS ChangeLog* MAINTAINERS NEWS README

%files devel
%_includedir/gee-%api_ver
%_libdir/libgee-%api_ver.so
%_pkgconfigdir/gee-%api_ver.pc
%_datadir/vala/vapi/gee-%api_ver.vapi

%files gir
%_typelibdir/Gee-%api_ver.typelib

%files gir-devel
%_girdir/Gee-%api_ver.gir

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
