%define api_ver 1.0

%def_enable tests
%def_enable docs
%def_enable introspection
%def_enable vala
# failed to init libusb in hasher
%def_disable check

Name: libgusb
Version: 0.3.4
Release: alt1

Summary: GLib wrapper around libusb1
Group: System/Libraries
License: LGPL-2.1
Url: https://gitorious.org/gusb/

# VCS: https://github.com/hughsie/libgusb.git
Source: http://people.freedesktop.org/~hughsient/releases/%name-%version.tar.xz

BuildRequires(pre): meson
BuildRequires: libgio-devel >= 2.44 libusb-devel >= 1.0.22
BuildRequires: gobject-introspection-devel
%{?_enable_docs:BuildRequires: gtk-doc}
%{?_enable_vala:BuildRequires: vala-tools}

%description
GUsb is a GObject wrapper for libusb that makes it easy to do
asynchronous control, bulk and interrupt transfers with proper
cancellation and integration into a mainloop.

%package devel
Summary: Libraries and headers for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
GLib headers and libraries for the GUsb library.

%package gir
Summary: GObject introspection data for GUsb
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the GUsb library.

%package gir-devel
Summary: GObject introspection devel data for GUsb
Group: Development/Other
BuildArch: noarch
Requires: %name-devel = %version-%release
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the GUsb library.

%package devel-doc
Summary: Development documentation for GUsb
Group: Development/C
BuildArch: noarch
Conflicts: %name-devel < %version

%description devel-doc
This package provides documentation for developing
applications that use GUsb library.


%prep
%setup

%build
%meson \
	-Dusb_ids=%_datadir/misc/usb.ids \
        %{?_disable_docs:-Ddocs=false} \
        %{?_disable_tests:-Dtests=false} \
	%{?_disable_introspection:-Dintrospection=false} \
        %{?_disable_vala:-Dvapi=false}
%meson_build

%install
%meson_install

%check
%meson_test

%files
%_libdir/%name.so.*
%doc README* AUTHORS NEWS

%files devel
%_bindir/gusbcmd
%_includedir/gusb-1/
%_libdir/%name.so
%_pkgconfigdir/gusb.pc
%{?_enable_vala:%_vapidir/gusb.*}

%if_enabled introspection
%files gir
%_typelibdir/GUsb-%api_ver.typelib

%files gir-devel
%_girdir/GUsb-%api_ver.gir
%endif

%if_enabled docs
%files devel-doc
%_datadir/gtk-doc/html/gusb/
%endif

%changelog
