Name: libisc-export-dhcp
Version: 9.11.32
Release: alt2

Summary: ISC BIND 9.9.x exportable libraries to build ISC DHCP
License: MPL-2.0
Group: System/Libraries
Url: http://www.isc.org/products/BIND/

%define vsuffix -P5
# NOTE: vsuffix removed from Source0
# ftp://ftp.isc.org/isc/bind9/%version%vsuffix/bind-%version%vsuffix.tar.gz
Source0: bind-%version.tar

# NB: there must be at least one patch :)
Patch0001: 0001-owl-warnings.patch
Patch0002: 0002-alt-owl-chroot.patch
Patch0003: 0003-alt-nofile.patch
Patch0004: 0004-Link-libirs-with-libdns-libisc-and-libisccfg.patch
Patch0005: 0005-Fix-build-on-ppc-with-LTO.patch

Obsoletes: libisc-export <= 9.9.9

%def_disable static
%def_enable ipv6
%def_with openssl

# due to broken configure script
BuildPreReq: gcc-c++

%{?_with_openssl:BuildPreReq: libssl-devel}

%define bind_export_libs isc dns isccfg irs

%package devel
Summary: ISC 9.9.x BIND development files for exportable libraries
Group: Development/C
Requires: %name = %version-%release
Obsoletes: libisc-export-devel <= 9.9.9
Conflicts: bind-devel

%description
This package contains shared libraries used to build ISC DHCP

%description devel
This package contains develompent files for ISC 9.9.x BIND libraries
used to build ISC DHCP.

%prep
%setup -n bind-%version

# NB: there must be at least one patch :)
%patch0001 -p2
%patch0002 -p2
%patch0003 -p2
%patch0004 -p2
%patch0005 -p2

sed -i '/# Large File/iAC_SYS_LARGEFILE' configure.ac

%build
%autoreconf
%configure \
	--localstatedir=/var \
	--with-randomdev=/dev/random \
	--disable-threads \
	--disable-linux-caps \
	 %{subst_with openssl} \
	 %{subst_enable ipv6} \
	 %{subst_enable static} \
	--enable-rrl \
	--enable-fetchlimit \
	--enable-exportlib \
	--with-export-libdir=%{_libdir} \
	--with-export-includedir=%{_includedir} \
	--includedir=%{_includedir}/bind9 \
	--disable-openssl-version-check \
	--with-libtool \
	--with-gssapi=no \
	--disable-isc-spnego \
	--without-python \
	#

sed -i \
	-e '/^SUBDIRS =/s/.*/SUBDIRS = make lib/i' \
	Makefile

sed -i -e \
	"/^SUBDIRS =/s/.*/SUBDIRS = %bind_export_libs/i" \
	lib/Makefile

for lib in %bind_export_libs
do
	find .  -name Makefile -exec sed  "s/lib${lib}\./lib${lib}-export\./g" -i {} \;
done;

%make_build

%install
%makeinstall_std

%define _unpackaged_files_terminate_build 1

%files
%_libdir/lib*-export.so.*
%exclude %_bindir/*
%exclude %_mandir/*/*
%exclude %_sysconfdir/*

%files devel
%_includedir/*
%_libdir/lib*-export.so

%changelog
