%define _unpackaged_files_terminate_build 1

# TODO: dependency on Field3D

# TODO: build and run tests

%define oname openimageio
%define soname 2.1

Name:           lib%oname
Version:        2.1.18.1
Release:        alt1
Summary:        Library for reading and writing images
Group:          System/Libraries

License:        BSD
URL:            https://sites.google.com/site/openimageio/home

# https://github.com/OpenImageIO/oiio.git
Source0:        %name-%version.tar

# Images for test suite
#Source1:        oiio-images.tar.gz

BuildRequires(pre): rpm-build-python3
BuildRequires:  python3-devel
BuildRequires:  cmake gcc-c++
BuildRequires:  txt2man
BuildRequires:  qt5-base-devel
BuildRequires:  boost-devel boost-python3-devel boost-filesystem-devel boost-asio-devel
BuildRequires:  libGLEW-devel
BuildRequires:  openexr-devel ilmbase-devel
BuildRequires:  libpng-devel libtiff-devel libjpeg-devel libopenjpeg2.0-devel
BuildRequires:  libgif-devel
BuildRequires:  libwebp-devel
BuildRequires:  libhdf5-devel
BuildRequires:  zlib-devel
BuildRequires:  libjasper-devel
BuildRequires:  libpugixml-devel
BuildRequires:  libraw-devel
BuildRequires:  librobin-map-devel
BuildRequires:  pybind11-devel
BuildRequires:  libsquish-devel
BuildRequires:  bzip2-devel
BuildRequires:  freetype2-devel
BuildRequires:  libfmt-devel
%ifnarch %e2k
BuildRequires:  libdcmtk-devel
BuildRequires:  libopencv-devel
%endif

# WARNING: OpenColorIO and OpenImageIO are cross dependent.
# If an ABI incompatible update is done in one, the other also needs to be
# rebuilt.
BuildRequires:  libopencolorio-devel


%description
OpenImageIO is a library for reading and writing images, and a bunch of related
classes, utilities, and applications. Main features include:
- Extremely simple but powerful ImageInput and ImageOutput APIs for reading and
  writing 2D images that is format agnostic.
- Format plugins for TIFF, JPEG/JFIF, OpenEXR, PNG, HDR/RGBE, Targa, JPEG-2000,
  DPX, Cineon, FITS, BMP, ICO, RMan Zfile, Softimage PIC, DDS, SGI,
  PNM/PPM/PGM/PBM, Field3d.
- An ImageCache class that transparently manages a cache so that it can access
  truly vast amounts of image data.

%package -n lib%oname%soname
Summary:        Library for reading and writing images
Group:          System/Libraries

%description -n lib%oname%soname
OpenImageIO is a library for reading and writing images, and a bunch of related
classes, utilities, and applications. Main features include:
- Extremely simple but powerful ImageInput and ImageOutput APIs for reading and
  writing 2D images that is format agnostic.
- Format plugins for TIFF, JPEG/JFIF, OpenEXR, PNG, HDR/RGBE, Targa, JPEG-2000,
  DPX, Cineon, FITS, BMP, ICO, RMan Zfile, Softimage PIC, DDS, SGI,
  PNM/PPM/PGM/PBM, Field3d.
- An ImageCache class that transparently manages a cache so that it can access
  truly vast amounts of image data.

%package -n python3-module-%oname
Summary:        Python-3 bindings for %oname
Group:          Development/Python3
Requires:       lib%oname%soname = %EVR

%description -n python3-module-%oname
Python bindings for %oname.

%package -n %oname-utils
Summary:        Command line utilities for %oname
Group:          Other
Requires:       lib%oname%soname = %EVR

%description -n %oname-utils
Command-line tools to manipulate and get information on images using the
%{name} library.


%package -n %oname-iv
Summary:        %oname based image viewer
Group:          Other
Requires:       lib%oname%soname = %EVR

%description -n %oname-iv
A really nice image viewer, iv, based on %oname classes (and so will work
with any formats for which plugins are available).


%package devel
Summary:        Documentation for %oname
Group:          Development/Other
Requires:       lib%oname%soname = %EVR

%description devel
Development files for package %name


%prep
%setup

# Remove bundled pugixml
rm -f src/include/OpenImageIO/pugixml.hpp \
      src/include/OpenImageIO/pugiconfig.hpp \
      src/libutil/OpenImageIO/pugixml.cpp

# Remove bundled tbb
rm -rf src/include/tbb

# Install test images
#rm -rf ../oiio-images && mkdir ../oiio-images && pushd ../oiio-images
#tar --strip-components=1 -xzf #{SOURCE1}

# Try disabling old CMP
sed -i "s/SET CMP0046 OLD/SET CMP0046 NEW/" CMakeLists.txt

%ifarch armh
sed -ri '/Qt5_FOUND AND OPENGL_FOUND/ s,iv_enabled,FALSE,' src/iv/CMakeLists.txt
%endif

%build
%ifarch %e2k
# skip x86 asm (reported upstream); suggested by darktemplar@
%add_optflags -DOIIO_NO_AVX=1 -DOIIO_NO_SSE=1 -U__AES__
%endif
%cmake \
	-DINCLUDE_INSTALL_DIR:PATH=%_includedir/%oname \
	-DPYTHON_VERSION=%_python3_version \
	-DBUILD_DOCS:BOOL=TRUE \
	-DINSTALL_DOCS:BOOL=FALSE \
	-DINSTALL_FONTS:BOOL=FALSE \
	-DUSE_EXTERNAL_PUGIXML:BOOL=TRUE \
	-DSTOP_ON_WARNING:BOOL=FALSE \
	-DUSE_CPP:STRING=14 \
	-DJPEG_INCLUDE_DIR=%_includedir \
	-DOPENJPEG_INCLUDE_DIR=$(pkg-config --variable=includedir libopenjp2) \
	-DOpenGL_GL_PREFERENCE=GLVND \
	-DVERBOSE=TRUE \
%ifarch %e2k
	-DUSE_SIMD=0 \
	-DSKIP_TESTS=1 \
%endif
	%nil

%cmake_build

%install
%cmakeinstall_std

# Move man pages to the right directory
mkdir -p %buildroot%_man1dir
cp -a BUILD/src/doc/*.1 %buildroot%_man1dir

%files -n lib%oname%soname
%doc CHANGES.md README.md
%doc LICENSE.md LICENSE-THIRD-PARTY.md
%_libdir/libOpenImageIO.so.%{soname}
%_libdir/libOpenImageIO.so.%{soname}.*
%_libdir/libOpenImageIO_Util.so.%{soname}
%_libdir/libOpenImageIO_Util.so.%{soname}.*

%files -n python3-module-%oname
%python3_sitelibdir/OpenImageIO.so

%files -n %oname-utils
%_bindir/*
%_man1dir/*.1*
%ifnarch armh
%exclude %_bindir/iv
%exclude %_man1dir/iv.1*

%files -n %oname-iv
%_bindir/iv
%_man1dir/iv.1*
%endif

%files devel
%_libdir/libOpenImageIO.so
%_libdir/libOpenImageIO_Util.so
%_includedir/*
%_libdir/pkgconfig/OpenImageIO.pc
%_libdir/cmake/*
%_datadir/cmake/Modules/FindOpenImageIO.cmake

%changelog
