%define _unpackaged_files_terminate_build 1

%def_disable debug
%def_disable static

%define upname libtorrent-rasterbar
%define soname 10

Name: libtorrent-rasterbar
Epoch: 3
Version: 1.2.10
Release: alt0.1.p9

Summary: libTorrent is a BitTorrent library written in C++ for *nix
License: BSD-3-Clause and BSL-1.0
Group: System/Libraries
Url: https://www.rasterbar.com/products/libtorrent/

# https://github.com/arvidn/libtorrent.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: libssl-devel
BuildRequires: zlib-devel
BuildRequires: boost-devel boost-asio-devel boost-filesystem
BuildRequires: boost-filesystem-devel boost-program_options-devel
BuildRequires: boost-multiprecision-devel
BuildRequires: python3-devel boost-python3-devel
BuildRequires: libGeoIP-devel

%description
libTorrent is designed to avoid redundant copying and storing of data
that other clients and libraries suffer from. libTorrent features:

* The client has full control over the polling of sockets.
* Sigc++ signals makes it easy for the client to react to events.
* Fast resume which checks the file modification time.
* Direct reading and writing from network to mmap'ed files.
* File hash check uses the same thread; client can control the rate;
  non-blocking and preload to memory with the mincore and madvise.
* File handler: fine-grained use of file read/write permissions, allows
  seeding of read-only files; allows torrents with unlimited number of
  files; opens closed files when mapping chunks to memory, with graceful
  error handling; support for files larger than 2 GB; different download
  priorities for files in the torrent.
* Multi-tracker support.
* No dependency on any specific HTTP library, the client implements a
  wrapper class.
* Dynamic request pipe size.
* Upload and download throttle.
* And much more...

%package -n %name%soname
Summary: libTorrent is a BitTorrent library written in C++ for *nix
Group: System/Libraries

%description -n %name%soname
libTorrent is designed to avoid redundant copying and storing of data
that other clients and libraries suffer from. libTorrent features:

* The client has full control over the polling of sockets.
* Sigc++ signals makes it easy for the client to react to events.
* Fast resume which checks the file modification time.
* Direct reading and writing from network to mmap'ed files.
* File hash check uses the same thread; client can control the rate;
  non-blocking and preload to memory with the mincore and madvise.
* File handler: fine-grained use of file read/write permissions, allows
  seeding of read-only files; allows torrents with unlimited number of
  files; opens closed files when mapping chunks to memory, with graceful
  error handling; support for files larger than 2 GB; different download
  priorities for files in the torrent.
* Multi-tracker support.
* No dependency on any specific HTTP library, the client implements a
  wrapper class.
* Dynamic request pipe size.
* Upload and download throttle.
* And much more...

%package -n %upname-devel
Summary: Development libraries and header files for libTorrent
Group: Development/C++
Requires: %name%soname = %EVR
Provides: libtorrent-rasterbar8-devel = %EVR
Conflicts: libtorrent-rasterbar8-devel < %EVR
Obsoletes: libtorrent-rasterbar8-devel < %EVR
Conflicts: libtorrent-rasterbar7-devel < %EVR
Obsoletes: libtorrent-rasterbar7-devel < %EVR
Conflicts: libtorrent-devel

%description -n %upname-devel
The libtorrent-devel package contains libraries and header files needed
to develop applications using libTorrent.

%if_enabled static
%package -n %upname-devel-static
Summary: Development static libraries for libTorrent
Group: Development/C++
Requires: %name%soname = %EVR
Provides: libtorrent-rasterbar7-devel-static = %EVR
Conflicts: libtorrent-rasterbar7-devel-static < %EVR

%description -n %upname-devel-static
The libtorrent-devel package contains static libraries needed
to develop applications using libTorrent.
%endif

%package -n python3-module-%upname
Summary: libTorrent python bindings
Group: Development/Python3
Requires: %name%soname = %EVR

%description -n python3-module-%upname
The python3-module-libtorrent-rasterbar contains
python-3 bindings to libTorrent.

%prep
%setup

mkdir -p build-aux
touch build-aux/config.rpath

%build
%add_optflags -std=c++14
%ifarch %mips32
export LIBS=-latomic
%endif

export PYTHON=%_bindir/python3

%autoreconf
%configure \
	%{subst_enable static} \
	%{subst_enable debug} \
	--with-boost-libdir=%_libdir \
	--enable-python-binding \
	--with-boost-python=boost_python%{python_version_nodots python3} \
	%nil

# git rid of c++11
sed s/-std=c++11//g < bindings/python/compile_cmd > bindings/python/compile_cmd.new || exit 1
mv -f bindings/python/compile_cmd.new bindings/python/compile_cmd

%make_build V=1

%install
%makeinstall_std

rm -f %buildroot%_libdir/*.la
%if_disabled static
rm -f %buildroot%_libdir/*.a
%endif

%files -n %name%soname
%doc AUTHORS ChangeLog NEWS README.rst
%doc COPYING LICENSE
%_libdir/*.so.%{soname}
%_libdir/*.so.%{soname}.*

%files -n %upname-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*
%_datadir/cmake/Modules/*.cmake

%if_enabled static
%files -n %upname-devel-static
%_libdir/*.a
%endif

%files -n python3-module-%upname
%python3_sitelibdir/libtorrent*.so
%python3_sitelibdir/*.egg-info

%changelog
