%add_optflags %optflags_shared
%define oldname unshield
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# github: https://fedoraproject.org/wiki/Packaging:SourceURL
%global commit fe6338bd8ec0d9ff2148a134fabab5a0423a0b90
%global shortcommit %(c=%{commit}; echo ${c:0:7})

Name:           libunshield
Version:        1.0
Release:        alt1_8
Summary:        Install InstallShield applications on a Pocket PC

Group:          Communications
License:        MIT
URL:            https://github.com/twogood/unshield
Source0:        https://github.com/twogood/unshield/archive/%{commit}/%{oldname}-%{version}-%{shortcommit}.tar.gz

BuildRequires:  zlib-devel
BuildRequires:  libtool-common
BuildRequires:  autoconf-common
BuildRequires:  automake-common
Source44: import.info
Provides: unshield = %{version}-%{release}

%description
This tool allows the extraction of InstallShield format cabinet files (which
are different from Microsoft cabinet files). It was initially developed as a
part of the SynCE project to aid with installing applications for Pocket PC
devices, which were often contained in InstallShield installers, but these days
that is rather less likely to be the primary use case.

%package devel
Group:          Development/Other
Summary:        Files needed for software development with %{oldname}
Requires:       %{name} = %{version}-%{release}
Requires:       pkg-config
Provides: unshield-devel = %{version}-%{release}

%description devel
The %{oldname}-devel package contains the files needed for development with
%{oldname}.

%prep
%setup -q -n %{oldname}-%{commit}

%build
./bootstrap
%configure --disable-static --disable-rpath
make LIBTOOL=%{_bindir}/libtool %{?_smp_mflags}

%install
make install DESTDIR=$RPM_BUILD_ROOT
rm -f $RPM_BUILD_ROOT%{_libdir}/libunshield.{,l}a

%files
%doc README LICENSE
%{_bindir}/unshield
%{_mandir}/man1/unshield.1*
%{_libdir}/libunshield.so.*

%files devel
%{_libdir}/libunshield.so
%{_includedir}/libunshield.h
%{_libdir}/pkgconfig/libunshield.pc

%changelog
