%set_verify_elf_method textrel=relaxed
%define _gtk_docdir %_datadir/gtk-doc/html
%define _libexecdir %_prefix/libexec
%define api_ver 4.0
%define pkglibexecdir %_libexecdir/webkit2gtk-%api_ver
%define ver_major 2.24
%define gtk_ver 3.0
%define gst_ver 1.14.3

%define oname webkit
%define _name webkitgtk

%def_disable gtkdoc
%def_enable x11
%def_enable wayland
%ifarch armh
%def_disable gold
%else
%def_enable gold
%endif

# since 2.19.x in some build environments
# while build webki2gtk-dep typelibs this error appears
# FATAL: Could not allocate gigacage memory with maxAlignment = ..
# To avoid it set GIGACAGE_ENABLED=0
%def_enable gigacage

%define smp %__nprocs

Name: libwebkitgtk4
Version: %ver_major.4
Release: alt1.3.p9

Summary: Web browser engine
Group: System/Libraries
License: %bsd %lgpl2plus
Url: https://www.webkitgtk.org/

Source: %url/releases/%_name-%version.tar.xz
Source1: webkit2gtk.env
Patch1: libwebkitgtk4-fix-build-with-icu-65.patch

Requires: gst-plugins-base1.0 >= %gst_ver gst-plugins-good1.0 gst-plugins-bad1.0 gst-libav
Requires: hyphen-en hyphen-ru

BuildRequires(pre): rpm-build-licenses rpm-build-gir
BuildRequires: /proc gcc-c++ cmake ccache libicu-devel >= 5.6.1 bison perl-Switch perl-JSON-PP zlib-devel
BuildRequires: chrpath
BuildRequires: flex >= 2.5.33
BuildRequires: gperf libjpeg-devel libpng-devel libwebp-devel libopenjpeg2.0-devel openjpeg-tools2.0
BuildRequires: libxml2-devel >= 2.6
BuildRequires: libXt-devel
BuildRequires: libgtk+3-devel >= 3.4.0 libepoxy-devel
BuildRequires: libgail3-devel >= 3.0
BuildRequires: libenchant2-devel >= 2.2.3
BuildRequires: libsqlite3-devel >= 3.0
BuildRequires: libxslt-devel >= 1.1.7
BuildRequires: gstreamer1.0-devel >= %gst_ver gst-plugins1.0-devel >= %gst_ver gst-plugins-bad1.0-devel
BuildRequires: librsvg-devel >= 2.2.0
BuildRequires: gtk-doc >= 1.10
BuildRequires: libsoup-devel >= 2.61.90
BuildRequires: libsecret-devel
BuildRequires: libpango-devel >= 1.21.0 libcairo-devel >= 1.10 libcairo-gobject-devel
BuildRequires: fontconfig-devel >= 2.4 libfreetype-devel libharfbuzz-devel libwoff2-devel
BuildRequires: libgio-devel >= 2.25.0
BuildRequires: python-modules-json
BuildRequires: ruby ruby-stdlibs libruby-devel
BuildRequires: libGL-devel libXcomposite-devel libXdamage-devel
BuildRequires: gobject-introspection-devel >= 0.9.5 libgtk+3-gir-devel libsoup-gir-devel
BuildRequires: geoclue2-devel libgeoclue2-devel
BuildRequires: libenchant-devel libhyphen-devel
BuildRequires: libat-spi2-core-devel at-spi2-atk-devel
BuildRequires: libgtk+2-devel libpixman-devel libexpat-devel

BuildRequires: libXdmcp-devel libxshmfence-devel libXxf86vm-devel
BuildRequires: libXinerama-devel libXi-devel libXrandr-devel
BuildRequires: libXcursor-devel libxkbcommon-devel
%{?_enable_wayland:BuildRequires: libwayland-server-devel libwayland-cursor-devel libwayland-egl-devel}
BuildRequires: libnotify-devel libgnutls-devel libnettle-devel
BuildRequires: libtasn1-devel libp11-kit-devel libgcrypt-devel
# for battery status
BuildRequires: libupower-devel

%description
WebKit is an open source web browser engine.
The GTK+ port of WebKit is intended to provide a browser component
primarily for users of the portable GTK+ UI toolkit on platforms like
Linux.

%package -n libwebkit2gtk
Summary: WebKit2 is a new API layer for WebKit
Group: System/Libraries
Provides: %name = %version-%release
Requires: libjavascriptcoregtk4 = %version-%release

%description -n libwebkit2gtk
WebKit2 is a new API layer for WebKit designed from the ground up to support a split process model,
where the web content (JavaScript, HTML, layout, etc) lives in a separate process from the application UI.
This model is very similar to what Google Chrome offers, with the major difference being
that we have built the process split model directly into the framework, allowing other clients of WebKit to use it.

%package -n %_name-minibrowser
Summary: Simple WebKit browser
Group: Networking/WWW
Requires: libwebkit2gtk = %version-%release

%description -n %_name-minibrowser
This package provides simple browser from webkitgtk project.

%package -n libwebkit2gtk-devel
Summary: Development files for WebKit GTK+ port
Group: Development/C++
Provides: %name-devel = %version-%release
Requires: libwebkit2gtk = %version-%release
Requires: libjavascriptcoregtk4-devel = %version-%release

%description -n libwebkit2gtk-devel
The GTK+ port of WebKit is intended to provide a browser component
primarily for users of the portable GTK+ UI toolkit on platforms like
Linux. This package contains development headers.

%package -n libwebkit2gtk-devel-doc
Summary: Development documentation for WebKit2GTK
Group: Development/Documentation
BuildArch: noarch
Conflicts: libwebkit2gtk < %version-%release

%description -n libwebkit2gtk-devel-doc
The GTK+ port of WebKit is intended to provide a browser component
primarily for users of the portable GTK+ UI toolkit on platforms like
Linux.

This package provides development documentation for WebKit2GTK.

%package -n libjavascriptcoregtk4
Summary: GTK+3 version of the JavaScriptCore engine
Group: System/Libraries

%description -n libjavascriptcoregtk4
This package provides GTK+3 version of the JavaScriptCore engine from
WebKit package.

%package -n libjavascriptcoregtk4-devel
Summary: Development files for JavaScriptCore library
Group: Development/C++
Requires: libjavascriptcoregtk4 = %version-%release

%description -n libjavascriptcoregtk4-devel
This package provides development files for GTK+3 version of the
JavaScriptCore engine.

%package -n jsc4
Summary: JavaScriptCore shell for WebKit GTK+
Group: Development/GNOME and GTK+
Requires: libjavascriptcoregtk4 = %version-%release
# since 2.14.1 jsc moved to %pkglibexecdir
#Conflicts: jsc

%description -n jsc4
jsc is a shell for JavaScriptCore, WebKit's JavaScript engine. It
allows you to interact with the JavaScript engine directly.

%package -n libwebkit2gtk-gir
Summary: GObject introspection data for the Webkit2GTK library
Group: System/Libraries
Requires: libwebkit2gtk = %version-%release
Requires: libjavascriptcoregtk4 = %version-%release
Requires: libjavascriptcoregtk4-gir  = %version-%release

%description -n libwebkit2gtk-gir
GObject introspection data for the Webkit2GTK library

%package -n libwebkit2gtk-gir-devel
Summary: GObject introspection devel data for the Webkit2GTK library
Group: Development/Other
BuildArch: noarch
Requires: libwebkit2gtk-gir = %version-%release
Requires: libwebkit2gtk-devel = %version-%release
Requires: libjavascriptcoregtk4-gir = %version-%release
Requires: libjavascriptcoregtk4-devel = %version-%release
Requires: libjavascriptcoregtk4-gir-devel = %version-%release

%description -n libwebkit2gtk-gir-devel
GObject introspection devel data for the Webkit2GTK library

%package -n libjavascriptcoregtk4-gir
Summary: GObject introspection data for the JavaScriptCore library
Group: System/Libraries
Requires: libjavascriptcoregtk4 = %version-%release

%description -n libjavascriptcoregtk4-gir
GObject introspection data for the JavaScriptCore library

%package -n libjavascriptcoregtk4-gir-devel
Summary: GObject introspection devel data for the JavaScriptCore library
Group: Development/Other
BuildArch: noarch
Requires: libjavascriptcoregtk4-gir = %version-%release
Requires: libjavascriptcoregtk4-devel = %version-%release

%description -n libjavascriptcoregtk4-gir-devel
GObject introspection devel data for the JavaScriptCore library

%prep
%setup -n %_name-%version
%patch1 -p2
# Remove bundled libraries
rm -rf Source/ThirdParty/gtest/
rm -rf Source/ThirdParty/qunit/

subst 's|Q\(unused-arguments\)|W\1|' Source/cmake/WebKitCompilerFlags.cmake

%build
# Decrease debuginfo verbosity and use linker flags to reduce memory consumption
%define optflags_debug -g1
%add_optflags -Wl,--no-keep-memory
%{?_disable_gold: %add_optflags -Wl,--reduce-memory-overheads}
%ifarch armh %ix86
%add_optflags -D_FILE_OFFSET_BITS=64
%endif
%ifarch %ix86
# since 2.24.1 sse2 required for %%ix86
%add_optflags -msse2 -mfpmath=sse
%endif

%ifarch x86_64 armh
n=%smp
[  "$n"  -lt  16  ]  ||  n=16
%if_disabled gigacage
export GIGACAGE_ENABLED=0
%endif
%endif

%cmake \
-DPORT=GTK \
-DCMAKE_BUILD_TYPE=Release \
-DENABLE_MINIBROWSER=ON \
%{?_enable_gtkdoc:-DENABLE_GTKDOC:BOOL=ON} \
%{?_enable_x11:-DENABLE_X11_TARGET:BOOL=ON} \
%{?_enable_wayland:-DENABLE_WAYLAND_TARGET:BOOL=ON} \
%{?_disable_gold:-DUSE_LD_GOLD:BOOL=OFF} \
%ifarch armh
-DENABLE_JIT=OFF \
-DENABLE_C_LOOP=ON \
-DENABLE_SAMPLING_PROFILER=OFF \
-DUSE_SYSTEM_MALLOC=ON \
%endif
#-DENABLE_TOUCH_EVENTS:BOOL=ON \
#-DENABLE_TOUCH_ICON_LOADING:BOOL=ON \
#-DENABLE_TOUCH_SLIDER:BOOL=ON \
#-Dbmalloc_LIBRARIES:STRING=-ldl
# automatically enabled on x86_64
#-DENABLE_FTL_JIT:BOOL=ON
#-DENABLE_FTPDIR:BOOL=ON \
#-DENABLE_TELEPHONE_NUMBER_DETECTION:BOOL=ON \
#-DENABLE_BATTERY_STATUS:BOOL=ON \
#-DENABLE_DEVICE_ORIENTATION:BOOL=ON \
#-DENABLE_ORIENTATION_EVENTS:BOOL=ON
%ifarch x86_64 armh
%make -j $n -C BUILD
%else
%cmake_build
%endif

%install
%cmakeinstall_std
%if_disabled gigacage
install -pD -m755 %SOURCE1 %buildroot%_rpmmacrosdir/webki2gtk.env
%endif

%find_lang WebKit2GTK-%api_ver

%files -n libwebkit2gtk -f WebKit2GTK-%api_ver.lang
%_bindir/WebKitWebDriver
%_libdir/libwebkit2gtk-%api_ver.so.*
%dir %pkglibexecdir
%pkglibexecdir/WebKitNetworkProcess
%pkglibexecdir/WebKitPluginProcess
%pkglibexecdir/WebKitPluginProcess2
%pkglibexecdir/WebKitWebProcess
%dir %_libdir/webkit2gtk-%api_ver
%dir %_libdir/webkit2gtk-%api_ver/injected-bundle
%_libdir/webkit2gtk-%api_ver/injected-bundle/libwebkit2gtkinjectedbundle.so
%doc NEWS

%files -n %_name-minibrowser
%pkglibexecdir/MiniBrowser

%files -n libwebkit2gtk-devel
%_libdir/libwebkit2gtk-%api_ver.so
%dir %_includedir/webkitgtk-%api_ver
%_includedir/webkitgtk-%api_ver/webkit2
%_includedir/webkitgtk-%api_ver/webkitdom
%_pkgconfigdir/webkit2gtk-%api_ver.pc
%_pkgconfigdir/webkit2gtk-web-extension-%api_ver.pc
%{?_disable_gigacage:%_rpmmacrosdir/webki2gtk.env}

%if_enabled gtkdoc
%files -n libwebkit2gtk-devel-doc
%_gtk_docdir/*
%endif

%files -n libjavascriptcoregtk4
%_libdir/libjavascriptcoregtk-%api_ver.so.*

%files -n libjavascriptcoregtk4-devel
%_includedir/webkitgtk-%api_ver/jsc/
%_includedir/webkitgtk-%api_ver/JavaScriptCore/
%_libdir/libjavascriptcoregtk-%api_ver.so
%_pkgconfigdir/javascriptcoregtk-%api_ver.pc

%files -n jsc4
%pkglibexecdir/jsc*

%files -n libwebkit2gtk-gir
%_typelibdir/WebKit2-%api_ver.typelib
%_typelibdir/WebKit2WebExtension-%api_ver.typelib

%files -n libwebkit2gtk-gir-devel
%_girdir/WebKit2-%api_ver.gir
%_girdir/WebKit2WebExtension-%api_ver.gir

%files -n libjavascriptcoregtk4-gir
%_typelibdir/JavaScriptCore-%api_ver.typelib

%files -n libjavascriptcoregtk4-gir-devel
%_girdir/JavaScriptCore-%api_ver.gir


%changelog
