%define _unpackaged_files_terminate_build 1

%filter_from_requires /python[0-9.]\+(Reporter)/d
%filter_from_requires /python[0-9.]\+(optpmap)/d

%global v_major 12
%global v_majmin %v_major.0
%global v_full %v_majmin.0
%global rcsuffix %nil
%global llvm_name llvm%v_majmin
%global clang_name clang%v_majmin
%global clangd_name clangd%v_majmin
%global lld_name lld%v_majmin
%global lldb_name lldb%v_majmin

%global llvm_default_name llvm%_llvm_version
%global clang_default_name clang%_llvm_version
%global lld_default_name lld%_llvm_version

%global llvm_prefix %_prefix/lib/llvm-%v_majmin
%global llvm_bindir %llvm_prefix/bin
%global llvm_libdir %llvm_prefix/%_lib
%global llvm_includedir %llvm_prefix/include
%global llvm_libexecdir %llvm_prefix/libexec
%global llvm_datadir %llvm_prefix/share
%global llvm_man1dir %llvm_datadir/man/man1
%global llvm_docdir %llvm_datadir/doc

# Decrease debuginfo verbosity to reduce memory consumption during final library linking
%ifarch %ix86 %arm
%define optflags_debug -g0
#define __nprocs 1
%else
%define optflags_debug -g1
%endif

%define hwasan_symbolize_arches x86_64 aarch64
%define lldb_arches x86_64 %arm

%def_disable tests
%ifarch x86_64 aarch64
%def_without clang
%else
%def_without clang
%endif

%define tarversion %v_full%rcsuffix
%if 0%rcsuffix==0
%define mversion %v_full
%else
%define mversion %v_full%{?rcsuffix:-%rcsuffix}
%endif

Name: %llvm_name
Version: %v_full
Release: alt2
Summary: The LLVM Compiler Infrastructure

Group: Development/C
License: Apache-2.0 with LLVM-exception
Url: http://llvm.org
Source0: https://github.com/llvm/llvm-project/releases/download/llvmorg-%mversion/llvm-%tarversion.src.tar.xz
Source1: https://github.com/llvm/llvm-project/releases/download/llvmorg-%mversion/clang-%tarversion.src.tar.xz
Source2: https://github.com/llvm/llvm-project/releases/download/llvmorg-%mversion/clang-tools-extra-%tarversion.src.tar.xz
Source3: https://github.com/llvm/llvm-project/releases/download/llvmorg-%mversion/lld-%tarversion.src.tar.xz
Source4: https://github.com/llvm/llvm-project/releases/download/llvmorg-%mversion/compiler-rt-%tarversion.src.tar.xz
Source5: https://github.com/llvm/llvm-project/releases/download/llvmorg-%mversion/lldb-%tarversion.src.tar.xz
Patch:  clang-alt-i586-fallback.patch
Patch1: clang-alt-triple.patch
Patch2: 0001-alt-llvm-config-Ignore-wrappers-when-looking-for-current.patch
Patch3: llvm-alt-fix-linking.patch
Patch4: llvm-alt-triple.patch
Patch5: compiler-rt-alt-i586-arch.patch
Patch6: RH-0001-CMake-Split-static-library-exports-into-their-own-ex.patch
Patch7: clang-alt-aarch64-dynamic-linker-path.patch
Patch8: clang-tools-extra-alt-gcc-0001-clangd-satisfy-ALT-gcc-s-Werror-return-type.patch
Patch9: lld-11-alt-mipsel-permit-textrels-by-default.patch
Patch10: llvm-10-alt-python3.patch
# TODO: upstream this
Patch11: hwasan_symbolize-python3.patch
Patch14: llvm-10-alt-riscv64-config-guess.patch
Patch15: llvm-cmake-resolve-symlinks-in-LLVMConfig.cmake.patch
Patch16: clang-cmake-resolve-symlinks-in-ClangConfig.cmake.patch
Patch17: clang-tools-extra-completion-model-cmake.patch
Patch18: lld-compact-unwind-encoding.h.patch
# https://reviews.llvm.org/D96367
Patch19: clang-D96367-bring-reporter-back.patch

%if_with clang
# https://bugs.altlinux.org/show_bug.cgi?id=34671
%set_verify_elf_method lint=skip
%endif

# ThinLTO requires /proc/cpuinfo to exist; so the same does llvm
BuildPreReq: /proc

# Obtain %%__python3 at prep stage.
BuildRequires(pre): rpm-build-python
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-llvm-common

BuildRequires(pre): cmake >= 3.4.3
BuildRequires: rpm-build >= 4.0.4-alt112 libncursesw-devel
BuildRequires: libstdc++-devel libffi-devel perl-Pod-Parser perl-devel
BuildRequires: python3-module-recommonmark zip zlib-devel binutils-devel ninja-build
%if_with clang
BuildRequires: %clang_default_name %llvm_default_name-devel %lld_default_name
%else
BuildRequires: gcc-c++
%endif

%define requires_filesystem Requires: %name-filesystem = %EVR
%requires_filesystem
Requires: llvm >= %_llvm_version

%description
LLVM is a compiler infrastructure designed for compile-time, link-time,
runtime, and idle-time optimization of programs from arbitrary
programming languages. The compiler infrastructure includes mirror sets
of programming tools as well as libraries with equivalent functionality.

%package filesystem
Group: Development/Other
Summary: Owns the installation prefix for LLVM

%description filesystem
This package owns the installation prefix for LLVM. It is designed to be
pulled in by all non-empty LLVM packages.

%package devel
Group: Development/C
Summary: Libraries and header files for LLVM
%requires_filesystem
Requires: llvm-devel >= %_llvm_version
Requires: %name = %EVR

%description devel
This package contains library and header files needed to develop new
native programs that use the LLVM infrastructure.

%package devel-static
Summary: Static libraries for LLVM
Group: Development/C
%requires_filesystem
Requires: llvm-devel-static >= %_llvm_version
Requires: %name-devel = %EVR

%description devel-static
This package contains static libraries needed to develop new
native programs that use the LLVM infrastructure.

%package libs
Group: Development/C
Summary: LLVM shared libraries
%requires_filesystem

%description libs
This package contains shared libraries needed to develop new
native programs that use LLVM.

%package doc
Summary: Documentation for LLVM
Group: Documentation
BuildArch: noarch
%requires_filesystem

%description doc
Documentation for the LLVM compiler infrastructure.

%package tools
Summary: Various minor tools bundled with LLVM
Group: Development/C
%requires_filesystem

%description tools
This package contains various tools maintained as part of LLVM, including
opt-viewer.

%package -n %clang_name
Summary: A C language family frontend for LLVM
Group: Development/C
%requires_filesystem
# clang uses various parts of GNU crt bundled with gcc.
# Should they be packaged separately?
Requires: gcc
Requires: clang >= %_llvm_version

%description -n %clang_name
clang: noun
    1. A loud, resonant, metallic sound.
    2. The strident call of a crane or goose.
    3. C-language family front-end toolkit.

The goal of the Clang project is to create a new C, C++, Objective C
and Objective C++ front-end for the LLVM compiler. Its tools are built
as libraries and designed to be loosely-coupled and extendable.

%package -n %clang_name-libs
Group: Development/C
Summary: clang shared libraries
%requires_filesystem
Requires: %clang_name-libs-support = %EVR

%description -n %clang_name-libs
Shared libraries for the clang compiler.

%package -n %clang_name-libs-support
Group: Development/C
Summary: Support for Clang's shared libraries
%requires_filesystem

%description -n %clang_name-libs-support
The Clang's shared libraries implement compilers for C and C++, and thus have
to bundle additional platform support headers and libraries for use within the
compilation product. This package contains the platform support.

%package -n %clang_name-libs-support-shared-runtimes
Group: Development/C
Summary: Shared runtimes for Clang's shared libraries
%requires_filesystem
Requires: %clang_name-libs-support = %EVR

%description -n %clang_name-libs-support-shared-runtimes
This package contains shared runtime libraries for Scudo and sanitizers.

%package -n %clang_name-devel
Summary: Header files for clang
Group: Development/C
%requires_filesystem
Requires: clang-devel >= %_llvm_version
Requires: %clang_name = %EVR

%description -n %clang_name-devel
This package contains header files for the Clang compiler.

%package -n %clang_name-devel-static
Summary: Static libraries for clang
Group: Development/C
%requires_filesystem
Requires: %clang_name-devel = %EVR

%description -n %clang_name-devel-static
This package contains static libraries for the Clang compiler.

%package -n %clang_name-analyzer
Summary: A source code analysis framework
Group: Development/C
BuildArch: noarch
%requires_filesystem
Requires: %clang_name = %EVR

%description -n %clang_name-analyzer
The Clang Static Analyzer consists of both a source code analysis
framework and a standalone tool that finds bugs in C and Objective-C
programs. The standalone tool is invoked from the command-line, and is
intended to run in tandem with a build of a project or code base.

%package -n %clang_name-tools
Summary: Various clang-based tools
Group: Development/C
%requires_filesystem
Requires: %clang_name = %EVR
Requires: clang-tools >= %_llvm_version

%description -n %clang_name-tools
This package contains various code analysis and manipulation tools based on
libclang, including clang-format.

%package -n %clang_name-doc
Summary: Documentation for Clang
Group: Documentation
BuildArch: noarch
%requires_filesystem

%description -n %clang_name-doc
Documentation for the Clang compiler front-end.

%package -n %clangd_name
Summary: A clang-based language server
Group: Development/C
%requires_filesystem
Requires: clangd >= %_llvm_version

%description -n %clangd_name
This package contains clangd, a Clang-based language server for C and C++.

%package -n %lld_name
Summary: LLD - The LLVM Linker
Group: Development/C
%requires_filesystem
Requires: lld >= %_llvm_version

%description -n %lld_name
LLD is a linker from the LLVM project. That is a drop-in replacement for system
linkers and runs much faster than them. It also provides features that are
useful for toolchain developers.

%package -n %lld_name-devel
Summary: Header files for LLD
Group: Development/C
%requires_filesystem
Requires: lld-devel >= %_llvm_version
Requires: %lld_name = %EVR

%description -n %lld_name-devel
This package contains header files for the LLD linker.

%package -n %lld_name-doc
Summary: Documentation for LLD
Group: Documentation
BuildArch: noarch
%requires_filesystem

%description -n %lld_name-doc
Documentation for the LLD linker.

%package -n %lldb_name
Summary: A next-level high-performance debugger
Group: Development/Debuggers
%requires_filesystem

%description -n %lldb_name
LLDB is a next generation, high-performance debugger. It is built as a set of
reusable components which highly leverage existing libraries in the larger LLVM
project, such as the Clang expression parser and the LLVM disassembler.

%package -n lib%lldb_name
Summary: Shared library for LLDB
Group: Development/Debuggers
%requires_filesystem

%description -n lib%lldb_name
This package contains the LLDB runtime library.

%package -n lib%lldb_name-devel
Summary: Development files for liblldb
Group: Development/Debuggers
%requires_filesystem

%description -n lib%lldb_name-devel
This package contains header files to build extensions over lldb, as well as
development symlinks for liblldb.

%package -n %lldb_name-doc
Summary: Documentation for LLDB
Group: Documentation
BuildArch: noarch
%requires_filesystem

%description -n %lldb_name-doc
Documentation for the LLDB debugger.

%prep
%setup -n llvm-%tarversion.src -a1 -a2 -a3 -a4 -a5
for pkg in clang lld lldb; do
   mv $pkg-%tarversion.src tools/$pkg
done
mv clang-tools-extra-%tarversion.src tools/clang/tools/extra
for pkg in compiler-rt; do
   mv $pkg-%tarversion.src projects/$pkg
done
%patch -p1 -b .alt-i586-fallback
%patch1 -p1 -b .alt-triple
%patch2 -p1
sed -i 's)"%%llvm_bindir")"%llvm_bindir")' lib/Support/Unix/Path.inc
%patch3 -p1 -b .alt-fix-linking
%patch4 -p1 -b .alt-triple
%patch5 -p1 -b .alt-i586-arch
%patch6 -p1
%patch7 -p1 -b .alt-aarch64-dynamic-linker
%patch8 -p1
%patch9 -p1 -b .alt-mipsel-permit-textrels-by-default
%patch10 -p1
%patch11 -p1
%patch14 -p1
%patch15 -p2
%patch16 -p1
%patch17 -p1
%patch18 -p1
%patch19 -p1

# LLVM 12 and onward deprecate Python 2:
# https://releases.llvm.org/12.0.0/docs/ReleaseNotes.html
# Explicitly use python3 in hashbangs.
subst '/^#!.*python$/s|python$|python3|' $(grep -Rl '#!.*python$' *)

%build
%define _cmake_skip_rpath -DCMAKE_SKIP_RPATH:BOOL=OFF
%define _cmake__builddir BUILD
%cmake -G Ninja \
	-DLLVM_PARALLEL_LINK_JOBS=1 \
	-DCMAKE_BUILD_TYPE=Release \
	-DCMAKE_INSTALL_PREFIX=%llvm_prefix \
	-DCMAKE_SKIP_INSTALL_RPATH:BOOL=OFF \
	-DBUILD_SHARED_LIBS:BOOL=OFF \
	-DLLVM_TARGETS_TO_BUILD="all" \
	-DLLVM_EXPERIMENTAL_TARGETS_TO_BUILD='AVR' \
	-DLLVM_ENABLE_LIBCXX:BOOL=OFF \
	-DLLVM_ENABLE_ZLIB:BOOL=ON \
	-DLLVM_ENABLE_FFI:BOOL=ON \
	-DLLVM_ENABLE_RTTI:BOOL=ON \
	-DLLVM_OPTIMIZED_TABLEGEN:BOOL=ON \
	-DLLVM_BINUTILS_INCDIR="%_includedir/bfd" \
	\
	-DCLANG_PLUGIN_SUPPORT:BOOL=ON \
	-DCLANG_LINK_CLANG_DYLIB=ON \
	\
	%if_with clang
	-DLLVM_ENABLE_LTO=Thin \
	-DCMAKE_C_COMPILER=clang \
	-DCMAKE_CXX_COMPILER=clang++ \
	-DCMAKE_RANLIB:PATH=%_bindir/llvm-ranlib \
	-DCMAKE_AR:PATH=%_bindir/llvm-ar \
	-DCMAKE_NM:PATH=%_bindir/llvm-nm \
	-DLLVM_ENABLE_LLD:BOOL=ON \
	%else
	-DLLVM_ENABLE_LTO=On \
	%ifnarch riscv64
	-DLLVM_USE_LINKER=gold \
	%endif
	-DCMAKE_AR:PATH=%_bindir/gcc-ar \
	-DCMAKE_NM:PATH=%_bindir/gcc-nm \
	-DCMAKE_RANLIB:PATH=%_bindir/gcc-ranlib \
	-DCMAKE_SHARED_LINKER_FLAGS="-Wl,-Bsymbolic" \
	%endif
	\
	-DLLVM_LIBDIR_SUFFIX="%_libsuff" \
	-DLLVM_BUILD_RUNTIME:BOOL=ON \
	\
	-DLLVM_INCLUDE_TOOLS:BOOL=ON \
	-DLLVM_BUILD_TOOLS:BOOL=ON \
	\
	%if_enabled tests
	-DLLVM_INCLUDE_TESTS:BOOL=ON \
	-DLLVM_BUILD_TESTS:BOOL=ON \
	-DLLDB_INCLUDE_TESTS:BOOL=ON \
	%else
		%if_with clang
		-DLLDB_TEST_COMPILER:PATH=%_bindir/clang \
		%else
		-DLLDB_TEST_COMPILER:PATH=%_bindir/gcc \
		%endif
	%endif
	\
	-DLLVM_INCLUDE_EXAMPLES:BOOL=ON \
	-DLLVM_BUILD_EXAMPLES:BOOL=OFF \
	\
	-DLLVM_INCLUDE_UTILS:BOOL=ON \
	-DLLVM_INSTALL_UTILS:BOOL=OFF \
	\
	-DLLVM_INCLUDE_DOCS:BOOL=ON \
	-DLLVM_BUILD_DOCS:BOOL=ON \
	-DLLVM_ENABLE_SPHINX:BOOL=ON \
	-DSPHINX_WARNINGS_AS_ERRORS:BOOL=OFF \
	-DSPHINX_EXECUTABLE=%_bindir/sphinx-build-3 \
	-DLLVM_ENABLE_DOXYGEN:BOOL=OFF \
	-DLLVM_BUILD_LLVM_DYLIB:BOOL=ON \
	-DLLVM_LINK_LLVM_DYLIB:BOOL=ON \
	-DLLVM_INSTALL_TOOLCHAIN_ONLY:BOOL=OFF \
	-DPYTHON_EXECUTABLE=%_bindir/python3

sed -i 's|man\ tools/lld/docs/docs-lld-html|man|' BUILD/build.ninja
ninja -vvv -j %__nprocs -C BUILD

%install
pushd BUILD
cmake -DCMAKE_INSTALL_PREFIX=%buildroot%llvm_prefix ../
sed -i 's|man\ tools/lld/docs/docs-lld-html|man|' build.ninja
sed -i '/^[[:space:]]*include.*tools\/lld\/docs\/cmake_install.cmake.*/d' tools/lld/cmake_install.cmake
popd
ninja -C BUILD install

# Prepare Clang documentation.
rm -rf BUILD/clang-docs
mkdir -p BUILD/clang-docs
for f in LICENSE.TXT NOTES.txt README.txt; do
  ln tools/clang/$f BUILD/clang-docs/
done
rm -rf tools/clang/docs/{doxygen*,Makefile*,*.graffle,tools}

install -m 0755 BUILD/%_lib/LLVMHello.so %buildroot%llvm_libdir/
install -m 0755 BUILD/%_lib/BugpointPasses.so %buildroot%llvm_libdir/
mkdir -p %buildroot%llvm_docdir/lld

%ifarch %ix86
cd %buildroot%llvm_libdir/clang/%v_full/lib/linux
ls *-i[3-9]86* | while read f; do ln -s $f $(echo $f | sed 's|i[3-9]86|i386|') ; done
%endif

# The following files are not used by LLVM builds for Linux.
rm -f %buildroot%llvm_bindir/argdumper
rm -f %buildroot%llvm_datadir/clang/clang-format-bbedit.applescript

# Install the clang bash completion.
mkdir -p %buildroot%_datadir/bash-completion/completions
ln -sr %buildroot%llvm_datadir/clang/bash-autocomplete.sh %buildroot%_datadir/bash-completion/completions/clang-%v_major

# Symlink executables to %_bindir.
mkdir -p %buildroot%_bindir
for b in %buildroot%llvm_bindir/*; do
	bb="$(basename "$b")"
	echo "$bb" | grep -q -- '-%v_major$' && continue # if already appended
	ln -srv "$b" "%buildroot%_bindir/$bb-%v_major"
done
# Symlink man pages to the man dirs.
for mand in %buildroot%llvm_datadir/man/man*; do
	mand_index="${mand##*/man}"
	for m in "$mand"/*.[1-9]*; do
		# Let's force compress the man page, then symlink it.
		# /usr/lib/llvm-12.0/share/man/manD/utilX.D.xz -> /usr/share/man/manD/utilX-12.D.xz
		# Otherwise, brp-alt(compress) keeps fucking us up.
		# It remakes the symlinks first, then compresses their targets,
		# severing the symlinks.
		/usr/lib/rpm/compress_files "$m"

		mb="$(basename "$m")" # e. g. llvm-ar.1.xz
		new_mb="${mb%%.[1-9]*}-%v_major.$mand_index" # e. g. llvm-ar-12.1.xz

		mkdir -p "%buildroot%_mandir/man$mand_index"
		ln -srv "$m" "%buildroot%_mandir/man$mand_index/$new_mb"
	done
done

# Symlink sonamed shared libraries in %llvm_prefix/%_libdir to %_libdir.
mkdir -p %buildroot%_libdir
find %buildroot%llvm_libdir/*.so* -type f | grep -E '^%buildroot%llvm_libdir/.*(%v_major)' | sort | tee %_tmppath/shared-objects \
	| sed 's)%llvm_libdir)%_libdir)' > %_tmppath/shared-object-links
paste %_tmppath/shared-objects %_tmppath/shared-object-links | while read object link; do
	ln -srv "$object" "$link"
done

# List all packaged binaries in this source package.
find %buildroot%_bindir/*-%v_major > %_tmppath/PATH-executables

# For paranoic reasons library packaging policy covers peculiar directory paths.
# If there are $A.a and $A.so in %llvm_libdir/clang, they should not end up in the
# same package (but can be co-installed on a system).
# Let's list all the $A.so for which $A.a exists into a separate package.
# We also consider i386-symlinks for iN86.
find %buildroot%llvm_libdir/clang -type f,l -name '*.a' -or -name '*.so' | \
    sed -r -n 's/^(\/.+)\.a$/\1/p; s/^(.+)\.so$/\1/p' | sort | uniq -d > %_tmppath/libclang-support-dupes
sed < %_tmppath/libclang-support-dupes 's)^%buildroot)); s/$/.a/' > %_tmppath/libclang-support-static-runtimes
sed < %_tmppath/libclang-support-dupes 's)^%buildroot)); s/$/.so/' > %_tmppath/libclang-support-shared-runtimes
sed < %_tmppath/libclang-support-shared-runtimes 's/^/%%exclude /' > %_tmppath/dyn-files-libclang-support
echo "Expelling likely redundant Clang shared runtimes:" && cat %_tmppath/dyn-files-libclang-support

# Emit executable list for %name.
# A tool can be accompanied by a man page or not.
awk -F'\t' '
$1 ~ "bin" { print "%llvm_bindir/" $2; print "%_bindir/" $2 "-%v_major"; }
$1 ~ "man" { print "%llvm_man1dir/" $2 ".1*"; print "%_man1dir/" $2 "-%v_major.1*"; }
' >%_tmppath/dyn-files-%name <<EOExecutableList
bin,man	bugpoint
bin,man	diagtool
bin,man	dsymutil
bin	ld64.lld.darwinnew
bin,man	llc
bin,man	lli
bin,man	llvm-addr2line
bin,man	llvm-ar
bin,man	llvm-as
bin,man	llvm-bcanalyzer
bin	llvm-bitcode-strip
bin	llvm-cat
bin	llvm-cfi-verify
bin,man	llvm-cov
bin	llvm-c-test
bin	llvm-cvtres
bin	llvm-cxxdump
bin,man	llvm-cxxfilt
bin,man	llvm-cxxmap
bin,man	llvm-diff
bin,man	llvm-dis
bin	llvm-dlltool
bin,man	llvm-dwarfdump
bin	llvm-dwp
bin	llvm-elfabi
bin,man	llvm-exegesis
bin,man	llvm-extract
bin	llvm-gsymutil
bin	llvm-ifs
bin,man	llvm-install-name-tool
bin	llvm-jitlink
bin,man	llvm-lib
bin,man	llvm-libtool-darwin
bin,man	llvm-link
bin,man	llvm-lipo
bin	llvm-lto
bin	llvm-lto2
bin	llvm-mc
bin,man	llvm-mca
bin	llvm-ml
bin	llvm-modextract
bin	llvm-mt
bin,man	llvm-nm
bin,man	llvm-objcopy
bin,man	llvm-objdump
bin	llvm-opt-report
bin,man	llvm-pdbutil
bin,man	llvm-profdata
bin,man	llvm-profgen
bin,man	llvm-ranlib
bin	llvm-rc
bin,man	llvm-readelf
bin,man	llvm-readobj
bin	llvm-reduce
bin	llvm-rtdyld
bin,man	llvm-size
bin	llvm-split
bin,man	llvm-stress
bin,man	llvm-strings
bin,man	llvm-strip
bin,man	llvm-symbolizer
bin	llvm-tblgen
bin	llvm-undname
bin	llvm-xray
bin	modularize
bin,man	opt
bin	pp-trace
bin	sancov
bin	sanstats
bin	split-file
bin	verify-uselistorder
man	xxx-tblgen

man	FileCheck
man	extraclangtools
man	lit
man	llvm-locstats
EOExecutableList

%check
%if_enabled tests
LD_LIBRARY_PATH=%buildroot%llvm_libdir:$LD_LIBRARY_PATH
export LD_LIBRARY_PATH
ninja -C BUILD check-all || :
%endif

# Do not generate dependencies for clang-{format,rename} plugins.
%add_findreq_skiplist %llvm_datadir/clang/*

%files filesystem
%dir %llvm_prefix
%dir %llvm_bindir
%dir %llvm_libdir
%dir %llvm_includedir
%dir %llvm_libexecdir
%dir %llvm_datadir
%dir %llvm_datadir/clang
%dir %llvm_datadir/man
%dir %llvm_man1dir
%dir %llvm_docdir

%files -f %_tmppath/dyn-files-%name
%doc CREDITS.TXT LICENSE.TXT README.txt

%files libs
%llvm_libdir/libLLVM-*.so
%_libdir/libLLVM-*.so
%llvm_libdir/libLTO.so.*
%_libdir/libLTO.so.*
%llvm_libdir/libRemarks.so.*
%_libdir/libRemarks.so.*

%files tools
%llvm_datadir/opt-viewer

%files devel
%llvm_bindir/llvm-config
%_bindir/llvm-config-%v_major
%llvm_man1dir/llvm-config.1.*
%_man1dir/llvm-config-%v_major.1.*
%llvm_includedir/llvm
%llvm_includedir/llvm-c
%llvm_libdir/libLLVM.so
%llvm_libdir/libLTO.so
%llvm_libdir/LLVMgold.so
%llvm_libdir/libRemarks.so
%llvm_libdir/LLVMHello.so
%llvm_libdir/BugpointPasses.so
%dir %llvm_libdir/cmake
%llvm_libdir/cmake/llvm
%exclude %llvm_libdir/cmake/llvm/LLVMStaticExports.cmake

%files devel-static
%llvm_libdir/*.a
%exclude %llvm_libdir/libclang*.a
%dir %llvm_libdir/cmake
%dir %llvm_libdir/cmake/llvm
%llvm_libdir/cmake/llvm/LLVMStaticExports.cmake

%files -n %clang_name
%doc BUILD/clang-docs/*
%llvm_bindir/clang-%v_major
%llvm_bindir/clang
%_bindir/clang-%v_major
%llvm_bindir/clang++
%_bindir/clang++-%v_major
%llvm_bindir/clang-cl
%_bindir/clang-cl-%v_major
%llvm_bindir/clang-cpp
%_bindir/clang-cpp-%v_major
%llvm_man1dir/clang.1*
%_man1dir/clang-%v_major.1*
%exclude %llvm_bindir/clang-check*
%exclude %_bindir/clang-check*
%exclude %llvm_bindir/clang-extdef-mapping*
%exclude %_bindir/clang-extdef-mapping*
%exclude %llvm_bindir/clang-format*
%exclude %_bindir/clang-format*
%exclude %llvm_bindir/git-clang-format*
%exclude %_bindir/git-clang-format*
%exclude %llvm_bindir/clang-offload-*
%exclude %_bindir/clang-offload-*
%exclude %llvm_bindir/clang-refactor*
%exclude %_bindir/clang-refactor*
%exclude %llvm_bindir/clang-rename*
%exclude %_bindir/clang-rename*
%llvm_datadir/clang/bash-autocomplete.sh
%_datadir/bash-completion/completions/clang*

%files -n %clang_name-libs
%llvm_libdir/libclang*.so.*
%_libdir/libclang*.so.*

%files -n %clang_name-libs-support -f %_tmppath/dyn-files-libclang-support
%llvm_libdir/clang
# clang-tools
%ifarch %hwasan_symbolize_arches
%exclude %llvm_libdir/clang/%v_full/bin/hwasan_symbolize
%endif

%files -n %clang_name-libs-support-shared-runtimes -f %_tmppath/libclang-support-shared-runtimes

%files -n %clang_name-devel
%llvm_includedir/clang
%llvm_includedir/clang-c
%llvm_includedir/clang-tidy
%llvm_libdir/libclang*.so
%dir %llvm_libdir/cmake
%llvm_libdir/cmake/clang

%files -n %clang_name-devel-static
%llvm_libdir/libclang*.a

%files -n %clang_name-analyzer
%llvm_prefix/libexec/*-analyzer
%llvm_bindir/scan-build
%_bindir/scan-build-%v_major
%llvm_bindir/scan-view
%_bindir/scan-view-%v_major
%llvm_datadir/scan-build
%llvm_datadir/scan-view
%llvm_man1dir/scan-build.1*
%_man1dir/scan-build-%v_major.1*

%files -n %clang_name-tools
%llvm_bindir/c-index-test
%_bindir/c-index-test-%v_major
%llvm_bindir/clang-*
%_bindir/clang-*
%exclude %llvm_bindir/clang-%v_major
%exclude %llvm_bindir/clang
%exclude %_bindir/*clang-%v_major
%exclude %llvm_bindir/clang++
%exclude %_bindir/clang++-%v_major
%exclude %llvm_bindir/clang-cl
%exclude %_bindir/clang-cl-%v_major
%exclude %llvm_bindir/clang-cpp
%exclude %_bindir/clang-cpp-%v_major
%llvm_bindir/find-all-symbols
%_bindir/find-all-symbols-%v_major
%llvm_bindir/hmaptool
%_bindir/hmaptool-%v_major
%llvm_datadir/clang
%exclude %llvm_datadir/clang/bash-autocomplete.sh
%ifarch %hwasan_symbolize_arches
%llvm_libdir/clang/%v_full/bin/hwasan_symbolize
%endif

%files -n %clangd_name
%llvm_bindir/clangd
%_bindir/clangd-%v_major

%files -n %lld_name
%llvm_bindir/lld
%_bindir/lld-%v_major
%llvm_bindir/lld-link
%_bindir/lld-link-%v_major
%llvm_bindir/ld*.lld
%_bindir/ld*.lld-%v_major
%llvm_bindir/wasm-ld
%_bindir/wasm-ld-%v_major

%files -n %lld_name-devel
%dir %llvm_includedir/lld
%llvm_includedir/lld/*
# see Patch18: lld-compact-unwind-encoding.h.patch
%llvm_includedir/mach-o
%dir %llvm_libdir/cmake
%llvm_libdir/cmake/lld

%files -n %lldb_name
%llvm_bindir/lldb
%_bindir/lldb-%v_major
# Temporarily exclude lldb man pages.
# %llvm_man1dir/lldb.1*
# %_man1dir/lldb-%v_major.1*
%llvm_bindir/lldb-argdumper
%_bindir/lldb-argdumper-%v_major
%llvm_bindir/lldb-instr
%_bindir/lldb-instr-%v_major
%llvm_bindir/lldb-server
%_bindir/lldb-server-%v_major
%llvm_bindir/lldb-vscode
%_bindir/lldb-vscode-%v_major

%files -n lib%lldb_name
%llvm_libdir/liblldb*.so.*
%_libdir/liblldb*.so.*

%files -n lib%lldb_name-devel
%llvm_includedir/lldb
%llvm_libdir/liblldb*.so
# %_libdir/liblldb*.so

%files doc
%doc %llvm_docdir/llvm

%files -n %clang_name-doc
%doc %llvm_docdir/clang
%doc %llvm_docdir/clang-tools

%files -n %lld_name-doc
%doc %llvm_docdir/lld

%files -n %lldb_name-doc
#doc %llvm_docdir/lldb

%changelog
