# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
BuildRequires: texlive-collection-latexrecommended
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}

Name:           londonlaw
Version:        0.3.0
Release:        alt2_0.9.pre2
Summary:        Online multiplayer version of a well known detective boardgame
License:        GPLv2
Group:          Games/Other
URL:            http://github.com/anyc/londonlaw
Source0:        http://github.com/anyc/londonlaw/archive/v0.3.0_pre2.tar.gz
Source1:        %{name}.desktop
Source2:        %{name}-server.desktop
BuildRequires:  python-devel python-module-wx3.0 ghostscript-utils ghostscript ImageMagick-tools
BuildRequires:  tex(latex) tex(fullpage.sty) desktop-file-utils
BuildArch:      noarch
Requires:       python-module-wx3.0 python-module-twisted-conch python-module-twisted-conch-gui python-module-twisted-core python-module-twisted-core-gui python-module-twisted-core-gui-tk python-module-twisted-core-gui-wx python-module-twisted-core-test python-module-twisted-logger python-module-twisted-mail python-module-twisted-names python-module-twisted-news python-module-twisted-pair python-module-twisted-positioning python-module-twisted-runner python-module-twisted-web python-module-twisted-words icon-theme-hicolor
Source44: import.info

%description
London Law is an online multiplayer version of a well known detective
boardgame. The game is unusually asymmetric; one player controls the movements
of the criminal Mr. X as he tries to evade the detectives, while another one to
five players control five detectives trying to track him down. Mr. X has an
advantage in access to transportation routes, and his precise location remains
hidden for most of the game. The detectives have only the advantage of superior
numbers, so they must work in concert to limit the criminal's options. London
Law features an attractive map overlaid on high-resolution satellite imagery.


%prep
%setup -q -n %{name}-%{version}_pre2
chmod +x setup.py


%build
./setup.py build
make -C doc manual.pdf


%install
./setup.py install --prefix=%{_prefix} --root=$RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/48x48/apps
convert londonlaw/guiclient/images/playericon1.jpg -resize 48x48 \
   $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/48x48/apps/%{name}.png

mkdir -p $RPM_BUILD_ROOT%{_datadir}/applications
desktop-file-install --dir=${RPM_BUILD_ROOT}%{_datadir}/applications %{SOURCE1}
desktop-file-install --dir=${RPM_BUILD_ROOT}%{_datadir}/applications %{SOURCE2}



%files
%doc COPYING doc/ChangeLog doc/TODO doc/*.pdf doc/readme.protocol
%{_bindir}/london-*
%{_datadir}/%{name}
%{python_sitelibdir_noarch}/%{name}
%{python_sitelibdir_noarch}/%{name}-%{version}*-py?.?.egg-info
%{_datadir}/applications/*%{name}*.desktop
%{_datadir}/icons/hicolor/48x48/apps/%{name}.png


%changelog
