%define pkgname labltk

Name: ocaml-%pkgname
Version: 8.06.5
Release: alt2

Summary: Tcl/Tk interface for OCaml
Group: Development/ML

License: LGPLv2+ with exceptions

Url: https://forge.ocamlcore.org/projects/labltk/
Source: %name-%version.tar

Conflicts: labltk

Requires: ocaml
Requires: %name-runtime = %version-%release
BuildRequires: ocaml
BuildRequires: tcl-devel, tk-devel

%description
Objective Caml is a high-level, strongly-typed, functional and
object-oriented programming language from the ML family of languages.

LablTk gives OCaml program access to Tcl/Tk GUI widgets. This package
contains files needed to develop OCaml programs using LablTk.

%package runtime
Summary: Tk toolkit bindings for OCaml
Group: Development/ML
Requires: ocaml-runtime
Conflicts: labltk-runtime

%description runtime
Objective Caml is a high-level, strongly-typed, functional and
object-oriented programming language from the ML family of languages.

LablTk gives OCaml program access to Tcl/Tk GUI widgets. This package
contains files needed to run bytecode OCaml programs using LablTk.

%package -n ocaml-ocamlbrowser
Summary: OCaml interface browser
Group: Development/ML
Requires: %name-runtime
Conflicts: ocamlbrowser

%description -n ocaml-ocamlbrowser
Objective Caml is a high-level, strongly-typed, functional and
object-oriented programming language from the ML family of languages.

This package provides OCamlBrowser, a source and compiled interface
browser, written using LablTk.

%prep
%setup -q

%build
./configure
make all
make opt

%install
mkdir -p %buildroot%_bindir
mkdir -p %buildroot%_libdir/ocaml/labltk
mkdir -p %buildroot%_libdir/ocaml/stublibs

make install \
    BINDIR=%buildroot%_bindir \
    INSTALLDIR=%buildroot%_libdir/ocaml/labltk \
    STUBLIBDIR=%buildroot%_libdir/ocaml/stublibs

%files
%doc Changes README.mlTk
%_bindir/labltk
%_libdir/ocaml/labltk
%exclude %_libdir/ocaml/labltk/*.cmi
%exclude %_libdir/ocaml/labltk/*.cma
%exclude %_libdir/ocaml/labltk/*.cmo

%files runtime
%_libdir/ocaml/stublibs/dlllabltk.so
%_libdir/ocaml/labltk/*.cmi
%_libdir/ocaml/labltk/*.cma
%_libdir/ocaml/labltk/*.cmo

%files -n ocaml-ocamlbrowser
%_bindir/ocamlbrowser

%changelog
