# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(IO/All.pm) perl(Mo.pm) perl(Term/ANSIColor.pm) perl(Test/Pod.pm) perl(Text/Diff.pm) perl(XXX.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Pegex
Version:        0.70
Release:        alt1_2
Summary:        Pegex Parser Generator
License:        GPL+ or Artistic
Group:          Development/Other
URL:            https://metacpan.org/release/Pegex
Source0:        https://cpan.metacpan.org/authors/id/I/IN/INGY/Pegex-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(File/ShareDir/Install.pm)
# Run-time
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(JSON/XS.pm) perl(JSON/PP.pm)
BuildRequires:  perl(overload.pm)
BuildRequires:  perl(re.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(YAML/XS.pm)
# Tests
BuildRequires:  perl(base.pm)
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Test/More.pm)
# TestML not used
# TestML::Compiler::Lite not used
Requires:       perl(Data/Dumper.pm)
Requires:       perl(JSON/XS.pm) perl(JSON/PP.pm)
Requires:       perl(warnings.pm)
Requires:       perl(YAML/XS.pm)
Source44: import.info

%description
Pegex is a Acmeist parser framework. It is a PEG parser grammar syntax,
combined with PCRE compatible regular expressions as the match tokens.
Pegex draws heavily from Perl 6 rules, but works equivalently in many
modern programming languages.

%prep
%setup -q -n Pegex-%{version}
## Remove bundled modules
#rm -r ./inc
#sed -i '63,$ d' Makefile.PL
sed -i -e '/^inc\//d' MANIFEST

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
#rm -f t/compiler-checks.t t/compiler-equivalence.t t/compiler.t t/error.t t/optimize.t t/tree-pegex.t t/tree.t
make test

%files
%doc Changes CONTRIBUTING LICENSE README
%{perl_vendor_privlib}/*

%changelog
