%define _unpackaged_files_terminate_build 1
%define dist Unicode-Map
Name: perl-%dist
Version: 0.112
Release: alt7.1

Summary: Maps charsets from and to utf16 unicode
License: GPL or Artistic
Group: Development/Perl

URL: %CPAN %dist
Source0: %dist-%version.tar.gz
Source1: http://www.unicode.org/Public/MAPPINGS/VENDORS/MISC/KOI8-R.TXT

# Automatically added by buildreq on Fri Oct 07 2011
BuildRequires: perl-devel perl-podlators

%description
This module converts strings from and to 2-byte Unicode UCS2 format.
All mappings happen via 2 byte UTF16 encodings, not via 1 byte UTF8
encoding. To transform these use Unicode::String.

%package scripts
Summary: %name scripts
Group: Development/Perl
Requires: %name = %EVR
Conflicts: %name < 0.112-alt7
BuildRequires: perl(HTTP/Status.pm) perl(LWP/Simple.pm)

%description scripts
scripts for %name


%prep
%setup -q -n %dist-%version

%build
# bootstrap
%perl_vendor_build

# add koi8-r support
mkdir -p Map/VENDORS/MISC
perl -Mblib tools/mkmapfile -M Map/VENDORS/MISC/KOI8-R.map %SOURCE1
[ -f Map/REGISTRY ]
cat <<\__EOF__ >>Map/REGISTRY
##
## ALT
##
name:    KOI8-R
srcURL:  $SrcUnicode/VENDORS/MISC/KOI8-R.TXT
src:     $DestUnicode/VENDORS/MISC/KOI8-R.TXT
map:     $DestMap/VENDORS/MISC/KOI8-R.map
alias:   csKOI8R
#mib:    ????
#
__EOF__

# rebuild
%perl_vendor_build

# test koi8-r support
perl -Mblib -MUnicode::Map -e 'Unicode::Map->new("KOI8-R") or die "KOI8-R broken\n"'

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/Unicode
%perl_vendor_autolib/Unicode

%files scripts
%_bindir/map
%_bindir/mkmapfile
%_bindir/mirrorMappings
%_bindir/mkCSGB2312
%_man1dir/*

%changelog
