%def_disable snapshot

%define ver_major 0.999
%define api_ver 1.0
%define gst_api_ver 1.0
# gst-transcoder version
%define gst_ver 1.14.1
%define gtk_ver 3.20
%define gi_ver 1.32

Name: pitivi
Version: %ver_major
Release: alt1

Summary: PiTiVi allows users to easily edit audio/video projects
License: LGPLv2.1+
Group: Video
Url: http://www.pitivi.org/

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Requires: gst-transcoder = %gst_ver-%release

# use python3
AutoReqProv: nopython
%define __python %nil
%add_python3_path %_libdir/%name/python

# should be provided by python3-module-gst1.0
%add_python3_req_skip gi.repository.GstPbutils

Requires: python3-module-gst%gst_api_ver >= %gst_ver
Requires: gstreamer-editing-services
Requires: gst-validate
Requires: gst-libav >= %gst_ver
Requires: gst-plugins-base%gst_api_ver >= %gst_ver
Requires: gst-plugins-good%gst_api_ver >= %gst_ver
Requires: gst-plugins-bad%gst_api_ver >= %gst_ver
Requires: gst-plugins-ugly%gst_api_ver >= %gst_ver
Requires: python3-module-canberra

BuildRequires(pre): rpm-build-python3
BuildRequires: git meson gtk-doc python3-module-nose2
BuildRequires: intltool yelp-tools rpm-build-gir libappstream-glib-devel libcairo-devel
BuildRequires: python3-devel python3-module-pygobject3-devel
BuildRequires: python3-module-pycairo-devel
BuildRequires: gst-plugins%gst_api_ver-devel
BuildRequires: libgtk+3-devel >= %gtk_ver gobject-introspection-devel >= %gi_ver
BuildRequires: libgstreamer%gst_api_ver-gir-devel gst-plugins%gst_api_ver-gir-devel
BuildRequires: gst-validate libgtk+3-gir-devel

%description
Pitivi is a video editor built upon the GStreamer Editing Services.
It aims to be an intuitive and flexible application that can appeal to
newbies and professionals alike.

%package -n gst-transcoder
Version: %gst_ver
Summary: GStreamer Transcoding library
Group: System/Libraries

%description -n gst-transcoder
This package provides GStreamer Transcoding library, tool and
GStreamer plugin.

%package -n gst-transcoder-devel
Version: %gst_ver
Summary: Development files for GStreamer Transcoder
Group: Development/C
Requires: gst-transcoder = %gst_ver-%release

%description -n gst-transcoder-devel
This package provides development files for GStreamer Transcoder.

%package -n gst-transcoder-devel-doc
Version: %gst_ver
Summary: Development documentation for GStreamer Transcoder
Group: Development/Documentation
Conflicts: gst-transcoder-devel < %gst_ver

%description -n gst-transcoder-devel-doc
This package provides development documentation for GStreamer Transcoder.


%prep
%setup

%build
%meson --wrap-mode=default
%meson_build

%install
%meson_install
%find_lang --with-gnome %name


%files -f %name.lang
%_bindir/%name
%_libdir/%name/
%_datadir/%name/
%_datadir/gstreamer-%gst_api_ver/encoding-profiles/
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/*/*
%_datadir/appdata/*.appdata.xml
%_datadir/mime/packages/*-mime.xml

%files -n gst-transcoder
%_bindir/gst-transcoder-%api_ver
%_libdir/libgsttranscoder-%api_ver.so.0
%_typelibdir/GstTranscoder-%api_ver.typelib
%_libdir/gstreamer-%gst_api_ver/libgsttranscode.so
%doc AUTHORS NEWS

%files -n gst-transcoder-devel
%_libdir/libgsttranscoder-%api_ver.so
%_pkgconfigdir/gst-transcoder-%api_ver.pc
%_includedir/gstreamer-%api_ver/gst/transcoder/
%_girdir/GstTranscoder-%api_ver.gir

%files -n gst-transcoder-devel-doc
%_datadir/gtk-doc/html/gstreamer-transcoder/

%changelog
