%define soversion 3
Summary: Parallel Virtual Machine
Name: pvm
Version: 3.4.6
Release: alt1.1.qa1
License: freely distributable
Group: System/Base
Url: http://www.epm.ornl.gov/pvm/pvm_home.html
Packager: Boris Savelev <boris@altlinux.org>

%define libname lib%name%soversion

Source: http://www.netlib.org/pvm3/pvm%version.tgz
Source2: pvmd.init
Patch1: 01-replace-pvmarch.patch
Patch6: 06-thread-safe-ctime.patch
Patch7: 07-new-manpages.patch
Patch9: 09-explicitly-declare-pvmnametag.patch
Patch10: 10-minor-manpage-fixes.patch
Patch11: 11-arm-has-tmpnam.patch
Patch12: 12-arm-uses-system-readline.patch
Patch13: 13-add-s390.patch
Patch14: 14-add-mips.patch
Patch15: 15-system-wide-pvmroot.patch
Patch16: 16-default-pvmroot.patch
Patch17: 17-fix-implicit-global-declarations.patch
Patch18: 18-m68k-has-not-fdset-struct.patch
Patch19: 19-sparc-has-const-syserr.patch
Patch20: 20-fix-kfreebsd-ftbfs.patch

Requires: %libname = %version-%release

# Automatically added by buildreq on Sun Jul 05 2009
BuildRequires: gcc-fortran libXaw-devel libXext-devel

%package -n %libname
Summary: Parallel Virtual Machine - shared libraries
Group: System/Libraries

%package devel
Summary: Parallel Virtual Machine - development files
Group: Development/Other
Requires: %libname = %version-%release

%package examples
Summary: Parallel Virtual Machine - examples
Group: Development/Other

%description
Console and communication daemon binaries for the Parallel Virtual
Machine.  Should be sufficient to utilize a node in a dynamically linked
PVM program such as pvmpov.

%description -n %libname
Just the bare library, required by binaries with optional PVM support such
as pvmpov.  Install the pvm package if you wish to actually run a parallel
job.

%description devel
Headers, man pages, documentation, auxiliary functions, and static
libraries for the Parallel Virtual Machine distributed memory
communications library.

%description examples
This package provides the examples distributed along with the Parallel
Virtual Machine. This can be useful for initial cluster or interoptability
testing.

%prep
%setup -n pvm3

%patch1 -p1
%patch6 -p1
%patch7 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1
%patch19 -p1
%patch20 -p1

subst "s|@libdir@|%_libdir|g" lib/aimk

%ifarch %ix86
%define pvm_arch LINUX
%else
%define pvm_arch LINUX64
%endif

%build
export AIMKSTR="-here -f ./conf/%pvm_arch.def -f ./Makefile.aimk"
export CFLOPTS_STRING='-g -fPIC %optflags -DRSHCOMMAND=\"%_libdir/pvm3/bin/rsh\" -DPVMDPATH=\"pvmd\" -DPVMDFILE=\"%_bindir/pvmd\" -DPVM_DEFAULT_ROOT=\"%_libdir/pvm3\" -DOVERLOADHOST'
FC="gfortran" F77="gfortran" PVM_ROOT=`pwd` ./lib/aimk $AIMKSTR CFLOPTS="$CFLOPTS_STRING" PVMDIR=`pwd` all

%install
mkdir -p %buildroot{%_bindir,%_includedir,%_datadir/%name}
mkdir -p %buildroot%_libdir/pvm3/{lib,conf}

# pvm package
cp lib/pvmgetarch %buildroot%_bindir
cp lib/%pvm_arch/pvm %buildroot%_bindir
cp lib/%pvm_arch/pvmgs %buildroot%_bindir
cp lib/%pvm_arch/pvmd3 %buildroot%_bindir/pvmd

ln -sf ../../../bin/pvmgetarch %buildroot%_libdir/pvm3/lib/pvmgetarch
ln -sf ../../../bin/pvm %buildroot%_libdir/pvm3/lib/pvm
ln -sf ../../../bin/pvmgs %buildroot%_libdir/pvm3/lib/pvmgs
ln -sf ../../../bin/pvmd %buildroot%_libdir/pvm3/lib/pvmd

# pvm-dev package
cp lib/aimk %buildroot%_bindir
mv bin/%pvm_arch/{pvm_gstat,pvmgroups,tracer,trcsort} %buildroot%_bindir
cp lib/%pvm_arch/*.a %buildroot%_libdir
cp conf/%pvm_arch.{def,m4} %buildroot%_libdir/pvm3/conf
cp include/* %buildroot%_includedir
ln -sf libpvm3.so.%version %buildroot%_libdir/libpvm3.so
ln -sf libgpvm3.so.%version %buildroot%_libdir/libgpvm3.so

# libpvm3 package
cp lib/%pvm_arch/libpvm3.so %buildroot%_libdir/libpvm3.so.%version
ln -s libpvm3.so.%version %buildroot%_libdir/libpvm3.so.%soversion
cp lib/%pvm_arch/libgpvm3.so %buildroot%_libdir/libgpvm3.so.%version
ln -s libgpvm3.so.%version %buildroot%_libdir/libgpvm3.so.%soversion

# pvm-examples package
mv bin/%pvm_arch/gs %buildroot%_bindir/gs.pvm
mv bin/%pvm_arch/hello %buildroot%_bindir/hello.pvm
mv bin/%pvm_arch/srm %buildroot%_bindir/srm.pvm
cp bin/%pvm_arch/* %buildroot%_bindir/
tar zcf %buildroot%_datadir/%name/examples.tar.gz examples
tar zcf %buildroot%_datadir/%name/gexamples.tar.gz gexamples

# init-stuff
mkdir -p %buildroot{%_var/run/pvm3,%_initdir}
cp %SOURCE2 %buildroot%_initdir/pvmd

# man
mkdir -p %buildroot{%_man1dir,%_man3dir}
cp man/man1/* %buildroot%_man1dir
cp man/man3/* %buildroot%_man3dir
cp hoster/*.3 %buildroot%_man3dir

#for p in %_man1dir %_man3dir ; do
#    cd %buildroot$p
#    list=`grep "\.so man" {*.3,*.1} | cut -d":" -f1`
#    for m in $list ; do
#        link=`grep "\.so man" $m | cut -d"/" -f2`
#        rm -f $m
#        ln -s $link $m
#    done
#done

%pre
%_sbindir/groupadd -r -f pvm > /dev/null 2>&1 ||:
%_sbindir/useradd -d %_libdir/pvm3 -r -s /bin/bash pvm > /dev/null 2>&1 ||:

%files
%doc Readme.mp Readme
#%_initdir/pvmd
%_bindir/pvmgs
%_bindir/pvmgetarch
%_bindir/pvm
%_bindir/pvmd
%dir %_libdir/pvm3
%dir %_libdir/pvm3/lib
%_libdir/pvm3/lib/pvmgs
%_libdir/pvm3/lib/pvmgetarch
%_libdir/pvm3/lib/pvm
%_libdir/pvm3/lib/pvmd
%_man1dir/*
%exclude %_man1dir/aimk.*
%exclude %_man1dir/pvmgroups.*
%exclude %_man1dir/pvm_shmd.*
%dir %_datadir/%name
%dir %attr(2775,root,pvm) /var/run/pvm3

%files -n %libname
%_libdir/*.so.*

%files devel
%_libdir/*.so
%_libdir/*.a
%_includedir/*
%dir %_libdir/pvm3/conf
%_libdir/pvm3/conf/*
%_bindir/aimk
%_bindir/pvm_gstat
%_bindir/pvmgroups
%_bindir/tracer
%_bindir/trcsort
%_man1dir/aimk.*
%_man1dir/pvmgroups.*
%_man1dir/pvm_shmd.*
%_man3dir/*

%files examples
%_bindir/*
%exclude %_bindir/aimk
%exclude %_bindir/pvm_gstat
%exclude %_bindir/pvmgroups
%exclude %_bindir/tracer
%exclude %_bindir/trcsort
%exclude %_bindir/pvmgs
%exclude %_bindir/pvmgetarch
%exclude %_bindir/pvm
%exclude %_bindir/pvmd
%_datadir/%name/*

%changelog
