%define version 1.6.4
%define release alt2
%setup_python_module PyQuante

Summary: PyQuante: Quantum Chemistry in Python
Name: %packagename
Version: %version
Release: %release
License: BSD
Group: Development/Python
URL: http://pyquante.sourceforge.net

Source: %modulename-%version.tar.gz

Requires: python-module-gnuplot
BuildRequires: python-devel python-module-distribute

# Automatically added by buildreq on Mon May 15 2006
BuildRequires: python-modules python-modules-compiler python-modules-encodings

%description
PyQuante is an open-source suite of programs for developing quantum
chemistry methods. The program is written in the Python programming
language, and has many 'rate-determining' modules also written in C
for speed. The resulting code is not nearly as fast as Jaguar,
Gaussian, or GAMESS, but the resulting code is much easier to
understand and modify. The goal of this software is not necessarily to
provide a working quantum chemistry program (although it will
hopefully do that), but rather to provide a well-engineered set of
tools so that scientists can construct their own quantum chemistry
programs without going through the tedium of having to write every
low-level routine. More information, including links to the download
page, is available at http://pyquante.sourceforge.net.

%package tests
Summary: Tests for PyQuante
Group: Development/Python
Requires: %name = %version-%release

%description tests
PyQuante is an open-source suite of programs for developing quantum
chemistry methods. The program is written in the Python programming
language, and has many 'rate-determining' modules also written in C
for speed. The resulting code is not nearly as fast as Jaguar,
Gaussian, or GAMESS, but the resulting code is much easier to
understand and modify. The goal of this software is not necessarily to
provide a working quantum chemistry program (although it will
hopefully do that), but rather to provide a well-engineered set of
tools so that scientists can construct their own quantum chemistry
programs without going through the tedium of having to write every
low-level routine. More information, including links to the download
page, is available at http://pyquante.sourceforge.net.

This package contains tests for PyQuante.

%prep
%setup -n %modulename-%version

%build
%python_build_debug

%install
%python_install --optimize=2

%files
%doc Doc LICENSE README Tests
%python_sitelibdir/PyQuante
%python_sitelibdir/PyQuante-%version-py*.egg-info
%exclude %python_sitelibdir/PyQuante/test_*

%files tests
%python_sitelibdir/PyQuante/test_*

%changelog
