%define _unpackaged_files_terminate_build 1

%def_with python3
%def_with check

%define oname dateutil

Name: python-module-%oname
Version: 2.7.3
Release: alt1
Summary: Extensions to the standard datetime module
License: PSF
Group: Development/Python
Url: https://pypi.python.org/pypi/python-dateutil/

BuildArch: noarch

Packager: Vitaly Lipatov <lav@altlinux.ru>

%add_python_req_skip _winreg winreg

# https://github.com/dateutil/dateutil.git
Source: %name-%version.tar

Patch1: %oname-%version-alt-tests.patch

BuildRequires: python-devel python-modules-encodings
BuildRequires: python-module-setuptools python-module-six
BuildRequires: pytz-zoneinfo
BuildRequires: python2.7(setuptools_scm)
%if_with check
BuildRequires: python2.7(pytest) python2.7(hypothesis) python2.7(freezegun)
%endif
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3(setuptools_scm)
%if_with check
BuildRequires: python3(pytest) python3(hypothesis) python3(freezegun)
%endif
%endif

Requires: pytz-zoneinfo

%description
The dateutil module provides powerful extensions to the standard
datetime module, available in Python 2.3+. Allows:
- computing of relative deltas (next month, next year, next monday,
  last week of month, etc),
- computing of dates based on very flexible recurrence rules, using a
  superset of the [WWW] iCalendar specification,
- parsing of RFC strings,
- peneric parsing of dates in almost any string format.

%if_with python3
%package -n python3-module-%oname
Summary: Extensions to the standard datetime module
Group: Development/Python3
Requires: pytz-zoneinfo
%add_python3_req_skip _winreg winreg

%description -n python3-module-%oname
The dateutil module provides powerful extensions to the standard
datetime module, available in Python 2.3+. Allows:
- computing of relative deltas (next month, next year, next monday,
  last week of month, etc),
- computing of dates based on very flexible recurrence rules, using a
  superset of the [WWW] iCalendar specification,
- parsing of RFC strings,
- peneric parsing of dates in almost any string format.
%endif

%prep
%setup
%patch1 -p1

%if_with python3
cp -fR . ../python3
%endif

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version

%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version

%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
export SETUPTOOLS_SCM_PRETEND_VERSION=%version

py.test

%if_with python3
pushd ../python3
py.test3
popd
%endif

%files
%doc LICENSE NEWS README*
%python_sitelibdir/*egg-info/
%python_sitelibdir/dateutil

%files -n python3-module-%oname
%doc LICENSE NEWS README*
%python3_sitelibdir/*egg-info/
%python3_sitelibdir/dateutil

%changelog
