%define _unpackaged_files_terminate_build 1
%define mname ldap

%def_with check

Name: python-module-%mname
Version: 3.2.0
Release: alt1

Summary: An object-oriented API to access LDAP directory servers from Python programs
License: Python-style
Group: Development/Python
Url: https://www.python-ldap.org
# Source-git: https://github.com/python-ldap/python-ldap

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: libldap-devel
BuildRequires: libsasl2-devel
BuildRequires: libssl-devel

%if_with check
BuildRequires: openldap-servers
BuildRequires: openldap-clients
BuildRequires: python2.7(coverage)
BuildRequires: python2.7(pyasn1_modules)
BuildRequires: python3(coverage)
BuildRequires: python3(pyasn1_modules)
BuildRequires: python3(tox)
%endif

Provides: python-module-pyldap = %EVR
Obsoletes: python-module-pyldap < %EVR

%description
python-ldap provides an object-oriented API to access LDAP
directory servers from Python programs. Mainly it wraps the
OpenLDAP client libs for that purpose.

Additionally the package contains modules for other LDAP-related
stuff (e.g. processing LDIF, LDAPURLs, LDAPv3 sub-schema, etc.).

%package -n python3-module-%mname
Summary: An object-oriented API to access LDAP directory servers from Python3 programs
Group: Development/Python3
Provides: python3-module-pyldap = %EVR
Obsoletes: python3-module-pyldap < %EVR

%description -n python3-module-%mname
python-ldap provides an object-oriented API to access LDAP
directory servers from Python3 programs. Mainly it wraps the
OpenLDAP client libs for that purpose.

Additionally the package contains modules for other LDAP-related
stuff (e.g. processing LDIF, LDAPURLs, LDAPv3 sub-schema, etc.).

%prep
%setup

cp -a . ../python3

# Fix python interpreter path in Demo directory
grep -rl '^#!/usr/bin/env python' ./ | \
	xargs sed -i '1s|^#!/usr/bin/env python|#!/usr/bin/python|'
grep -rl '^#!/usr/bin/env python' ../python3 | \
	xargs sed -i '1s|^#!/usr/bin/env python|#!/usr/bin/python3|'

%build
%add_optflags -fno-strict-aliasing
%python_build_debug

pushd ../python3
%python3_build_debug
popd

%check
export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python},py%{python_version_nodots python3}
tox.py3 --sitepackages -p auto -o -v

%install
%python_install

pushd ../python3
%python3_install
popd

%files
%doc LICENCE CHANGES README TODO Demo
%exclude %python_sitelibdir/slapdtest
%python_sitelibdir/_ldap.so
%python_sitelibdir/ldap
%python_sitelibdir/ldapurl.py*
%python_sitelibdir/ldif.py*
%python_sitelibdir/python_ldap-%{version}*-*.egg-info

%files -n python3-module-%mname
%doc LICENCE CHANGES README TODO Demo
%exclude %python3_sitelibdir/slapdtest
%python3_sitelibdir/_ldap.cpython-*.so
%python3_sitelibdir/ldap
%python3_sitelibdir/ldapurl.py*
%python3_sitelibdir/ldif.py*
%python3_sitelibdir/__pycache__/*
%python3_sitelibdir/python_ldap-%{version}*-*.egg-info

%changelog
