%define _unpackaged_files_terminate_build 1

%define oname mimeparse

%def_with python3

Name: python-module-%oname
Version: 1.6.0
Release: alt1.qa1%ubt
Summary: Basic functions for handling mime-types in python
License: MIT
Group: Development/Python
BuildArch: noarch
Url: https://pypi.org/project/python-mimeparse

# https://github.com/dbtsai/python-mimeparse.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-ubt
BuildRequires: python-devel python-module-setuptools
BuildRequires: python2.7(json)
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-dev python3-module-setuptools
BuildRequires: python3(json)
%endif

%description
This module provides basic functions for handling mime-types. It can handle
matching mime-types against a list of media-ranges. See section 14.1 of 
the HTTP specification [RFC 2616] for a complete explanation.

   http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.1

Contents:
    - parse_mime_type():   Parses a mime-type into its component parts.
    - parse_media_range(): Media-ranges are mime-types with wild-cards
      and a 'q' quality parameter.
    - quality():           Determines the quality ('q') of a mime-type
      when compared against a list of media-ranges.
    - quality_parsed():    Just like quality() except the second
      parameter must be pre-parsed.
    - best_match():        Choose the mime-type with the highest quality
      ('q') from a list of candidates.

%if_with python3
%package -n python3-module-%oname
Summary: Basic functions for handling mime-types in python
Group: Development/Python3

%description -n python3-module-%oname
This module provides basic functions for handling mime-types. It can handle
matching mime-types against a list of media-ranges. See section 14.1 of 
the HTTP specification [RFC 2616] for a complete explanation.

   http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.1

Contents:
    - parse_mime_type():   Parses a mime-type into its component parts.
    - parse_media_range(): Media-ranges are mime-types with wild-cards
      and a 'q' quality parameter.
    - quality():           Determines the quality ('q') of a mime-type
      when compared against a list of media-ranges.
    - quality_parsed():    Just like quality() except the second
      parameter must be pre-parsed.
    - best_match():        Choose the mime-type with the highest quality
      ('q') from a list of candidates.
%endif

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
python mimeparse_test.py

%if_with python3
pushd ../python3
python3 mimeparse_test.py
popd
%endif


%files
%doc README.rst LICENSE
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%doc README.rst LICENSE
%python3_sitelibdir/*
%endif

%changelog
