%define oname pyftpdlib
%define fname python-module-%oname
%define descr \
Python FTP server library provides a high-level portable interface to easily \
write asynchronous FTP servers with Python. pyftpdlib is currently the most \
complete RFC-959 FTP server implementation available for Python programming \
language.

Name: %fname-docs
Version: 1.5.4
Release: alt3

%if "-docs"==""
Summary: Python FTP server library
Summary(ru_RU.UTF-8): Модуль Python FTP-сервера
Group: Development/Python
%else
Summary: Documentation for %oname
Group: Development/Documentation
%endif

License: MIT
BuildArch: noarch
Url: https://github.com/giampaolo/pyftpdlib
Source: %name-%version.tar
Patch1: %oname-alt-tests.patch

BuildRequires(pre): rpm-macros-branch rpm-build-licenses
BuildRequires: python-module-sphinx-devel python-module-sphinx_rtd_theme
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools

%if "-docs"!=""
Conflicts: %fname < %EVR
Conflicts: %fname > %EVR
%else
%py_provides %oname
%if ""==""
%py_requires sendfile
%endif
%endif

%if "-docs"==""
%description -l ru_RU.UTF-8
Модуль Python FTP-сервера беспечивает портативный высокоуровневый интерфейс
для лёгкого написания асинхронного FTP сервера на Python. pyftpdlib сейчас --
наиболее полная реализация RFC-959 FTP-сервера для Python.
%endif

%description
%descr

%if "-docs"!=""
This package contains documentation for %oname.

%package -n %fname-pickles
Summary: Pickles for %oname
Group: Development/Python

%description -n %fname-pickles
%descr

This package contains pickles for %oname.

%else

%package tests
Summary: Documentation for %oname
Group: Development/Python
%py_requires %oname

%description tests
%descr

This package contains tests for %oname.
%endif

%prep
%setup
%if "-docs"==""
%patch1 -p1
%endif

sed -i -e "s|^__ver__ = '[^']*'|__ver__ = '%version'|" pyftpdlib/__init__.py

%if "-docs"!=""
%prepare_sphinx .
ln -s ../objects.inv docs/
%endif

%build
%if "-docs"==""
%python_build
%else
export PYTHONPATH=%buildroot%python_sitelibdir
%make -C docs pickle
%make -C docs html
%endif

%install
%if "-docs"==""
%python_install
%else
mkdir -p %buildroot%python_sitelibdir/%oname/
cp -fR docs/_build/pickle %buildroot%python_sitelibdir/%oname/
%endif

%if "-docs"==""
%if ""=="3"
pushd %buildroot%_bindir
for i in $(ls); do
    mv $i $i.py3
done
popd
%endif

%files
%doc CREDITS LICENSE *.rst demo/
%_bindir/*
%python_sitelibdir/%oname/
%python_sitelibdir/*.egg-info*
%exclude %python_sitelibdir/%oname/test

%files tests
%python_sitelibdir/%oname/test
%exclude %python_sitelibdir/%oname/test/README

%else

%files
%doc docs/_build/html/*

%files -n %fname-pickles
%python_sitelibdir/%oname/pickle
%endif

%changelog
