%define _unpackaged_files_terminate_build 1
%define modulename virtualenv

%def_with check

Name: python-module-%modulename
Version: 16.5.0
Release: alt1.p9.1

Summary: Virtual Python Environment builder
License: MIT
Group: Development/Python
# git://github.com/pypa/virtualenv.git
Url: http://pypi.python.org/pypi/virtualenv

Source: %name-%version.tar.gz
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python2.7(coverage)
BuildRequires: python2.7(json)
BuildRequires: python2.7(mock)
BuildRequires: python2.7(nose)
BuildRequires: python2.7(pip)
BuildRequires: python2.7(pytest_timeout)
BuildRequires: python2.7(pytest-xdist)
BuildRequires: python3(coverage)
BuildRequires: python3(nose)
BuildRequires: python3(pip)
BuildRequires: python3(pytest_timeout)
BuildRequires: python3(pytest-xdist)
BuildRequires: python3(tox)
%endif

BuildArch: noarch
# json is not direct dep, but it is required to
# use bundled 'pip' whl package, otherwise installation fails
Requires: python-modules-json

%description
Tool to create isolated Python environments.

With virtualenv it is became possible to keep separate set of python libraries
for each of your project.

Just exec "virtualenv /your/dir" and whole python enviroment (including
setuptools and easy_install) will be installed there. You could exec scripts
in newly created environment by invoking /your/dir/bin/python

%description -l ru_RU.UTF-8
Утилита для создания изолированных окружений для Python.

С Virtualenv вы можете создать независимые наборы библиотек для каждого
вашего проекта. Опционально вы можете запретить использование системных
библиотек.

Просто выполните "virtualenv /your/dir" и полное виртуальное окружение Python
будет создано в каталоге, который вы указали (setuptools  и easy_install будут
также установлены и при вызове будут устанавливать новые библиотеки в ваше
виртуальное окружение). Чтобы выполнить ваши скрипты в вновь созданном окружение
запускайте их при помощи /your/dir/bin/python

%package -n python3-module-%modulename
Summary: Virtual Python 3 Environment builder
Group: Development/Python3

%description -n python3-module-%modulename
Tool to create isolated Python environments.

With virtualenv it is became possible to keep separate set of python libraries
for each of your project.

Just exec "virtualenv /your/dir" and whole python enviroment (including
setuptools and easy_install) will be installed there. You could exec scripts
in newly created environment by invoking /your/dir/bin/python

%prep
%setup
%patch -p1

# to reflect virtualenv_embedded/ updates on virtualenv.py
# if any file was changed under this directory then it's
# hash is updated in virtualenv.py and returns 1 otherwise 0
python3 tasks/update_embedded.py || python3 tasks/update_embedded.py

rm -rf ../python3
cp -a . ../python3

%build
%python_build

pushd ../python3
%python3_build
popd

%install
pushd ../python3
%python3_install
mv %buildroot%_bindir/{virtualenv,virtualenv3}
popd

%python_install

%check
# we don't package pytest 4.x yet
grep -qsF 'pytest >= 4.0.0, <5' setup.cfg || exit 1
sed -i 's/pytest >= 4.0.0, <5/pytest/g' setup.cfg

# another one workaround for pytest 3.x
grep -rlF 'monkeypatch.chdir(tmp_path)' | \
xargs sed -i 's/monkeypatch.chdir(tmp_path)/monkeypatch.chdir(str(tmp_path))/g'

sed -i '/\[testenv\]/a whitelist_externals =\
    \/bin\/cp\
    \/bin\/sed\
commands_pre =\
    \/bin\/cp %_bindir\/coverage \{envbindir\}\/coverage\
    \/bin\/sed -i \x271c #!\{envpython\}\x27 \{envbindir\}\/coverage' tox.ini

export PIP_NO_INDEX=YES
export PIP_FIND_LINKS=`pwd`/build/lib/virtualenv_support
export TOX_TESTENV_PASSENV='PIP_NO_INDEX PIP_FIND_LINKS'
export TOXENV=py%{python_version_nodots python},py%{python_version_nodots python3}
tox.py3 --sitepackages -p auto -o -vr

%files
%doc docs/* *.txt *.rst
%_bindir/virtualenv
%exclude %_bindir/virtualenv3
%python_sitelibdir/virtualenv.py*
%python_sitelibdir/virtualenv-*.egg-info/
%python_sitelibdir/virtualenv_support/

%files -n python3-module-%modulename
%doc docs/* *.txt *.rst
%_bindir/virtualenv3
%python3_sitelibdir/virtualenv.py
%python3_sitelibdir/virtualenv-*.egg-info/
%python3_sitelibdir/virtualenv_support/
%python3_sitelibdir/__pycache__/virtualenv.*

%changelog
