%define project PyYAML

%def_with python3

Name: python-module-yaml
Version: 5.4.1
Release: alt0.p9

Summary: PyYAML, a YAML parser and emitter for Python

License: MIT
Group: Development/Python
Url: https://github.com/yaml/pyyaml
#BuildArch: noarch

# Source-url: https://github.com/yaml/pyyaml/archive/%version.tar.gz
Source: %name-%version.tar

BuildRequires(pre): rpm-build-intro >= 2.0.0

BuildRequires: python-devel libyaml-devel python-module-Cython
%if_with python3
BuildRequires(pre): rpm-build-python3 python3-module-Cython
BuildRequires: python3-devel
%endif

%description
YAML is a data serialization format designed for human readability
and interaction with scripting languages.

PyYAML is a YAML parser and emitter for the Python programming
language.  PyYAML features a complete YAML 1.1 parser, Unicode
support, and relatively sensible error messages.

%if_with python3
%package -n python3-module-yaml
Summary: PyYAML, a YAML parser and emitter for Python3
Group: Development/Python3

%description -n python3-module-yaml
YAML is a data serialization format designed for human readability
and interaction with scripting languages.

PyYAML is a YAML parser and emitter for the Python3 programming
language.  PyYAML features a complete YAML 1.1 parser, Unicode
support, and relatively sensible error messages.
%endif

%prep
%setup
%python3_dirsetup

%build
%add_optflags -fno-strict-aliasing

%python_build build_ext
%if_with python3
pushd ../python3
%python3_build build_ext
popd
%endif

%install
%python_install
%python3_dirinstall

%files
%doc CHANGES README
%python_sitelibdir/*

%if_with python3
%files -n python3-module-yaml
%python3_sitelibdir/*
%endif

%changelog
