%define oname Chaco

Name: python3-module-%oname
Version: 4.8.0.0.91.git22972069
Release: alt1

Summary: Interactive 2-Dimensional Plotting
License: BSD and GPLv2
Group: Development/Python3
URL: http://code.enthought.com/projects/chaco/

# https://github.com/enthought/chaco.git
Source: %oname-%version.tar.gz

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3
BuildRequires: libnumpy-py3-devel
BuildRequires: python3-module-sphinx python3-module-Pygments
BuildRequires: python3-module-traits
BuildRequires: python3-module-Cython


%description
Chaco is a Python plotting application toolkit that facilitates writing
plotting applications at all levels of complexity, from simple scripts with
hard-coded data to large plotting programs with complex data interrelationships
and a multitude of interactive tools. While Chaco generates attractive static
plots for publication and presentation, it also works well for interactive data
visualization and exploration.

%package tests
Summary: Tests for Chaco (Interactive 2-Dimensional Plotting)
Group: Development/Python3
Requires: %name = %EVR

%description tests
Chaco is a Python plotting application toolkit that facilitates writing
plotting applications at all levels of complexity, from simple scripts with
hard-coded data to large plotting programs with complex data interrelationships
and a multitude of interactive tools. While Chaco generates attractive static
plots for publication and presentation, it also works well for interactive data
visualization and exploration.

This package contains tests for Chaco.

%package doc
Summary: Documentation for Chaco (Interactive 2-Dimensional Plotting)
Group: Development/Documentation
BuildArch: noarch

%description doc
Chaco is a Python plotting application toolkit that facilitates writing
plotting applications at all levels of complexity, from simple scripts with
hard-coded data to large plotting programs with complex data interrelationships
and a multitude of interactive tools. While Chaco generates attractive static
plots for publication and presentation, it also works well for interactive data
visualization and exploration.

This package contains documentation for Chaco.

%prep
%setup

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%add_optflags -fno-strict-aliasing
%python3_build_debug

%install
%python3_install
%python3_prune
rm -rfv %buildroot%python3_sitelibdir/chaco/tests_with_backend/

export PYTHONPATH=%buildroot%python3_sitelibdir:$PWD/docs/source/sphinxext
sphinx-build-3 -E -a -b html -c docs/source -d doctrees docs/source html

%files
%doc *.txt
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/example*
%if 0
%exclude %python3_sitelibdir/*/tests
%exclude %python3_sitelibdir/*/*/tests

%files tests
%python3_sitelibdir/*/tests
%python3_sitelibdir/*/*/tests
%endif

%files doc
%doc docs/*.txt docs/*.pdf docs/*.tgz docs/chaco* docs/scipy_tutorial
%doc examples html


%changelog
