%define branch 2.2
%define origname Django
%define oname django

%def_disable check

%add_python3_req_skip cx_Oracle
%add_python3_req_skip hotshot StringIO
%add_findreq_skiplist %python3_sitelibdir/%oname/contrib/gis/db/backends/*/*

Summary: A high-level Python 3 Web framework that encourages rapid development and clean, pragmatic design.
Name: python3-module-%oname
Version: 2.2.25
Release: alt1
Source0: %origname-%version.tar
License: BSD
Group: Development/Python3
BuildArch: noarch
URL: http://www.djangoproject.com/
Provides: %name%branch = %EVR
Provides: %name%branch-tests = %EVR
Obsoletes: %name%branch < %EVR
Obsoletes: %name%branch-tests < %EVR
Provides: %name-tests = %EVR
Obsoletes: %name-tests < %EVR

%py3_provides django.utils.six.moves
%py3_provides django.utils.six.moves.urllib.parse
%py3_provides django.utils.six.moves.urllib.request
%py3_provides django.core.management.commands.loaddata
%py3_provides django.core.management.commands.test
%py3_provides django.core.management.commands.runserver

Conflicts: python3-module-django1.11
Conflicts: python3-module-django1.11-tests

%add_python3_req_skip django.test.signals

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-six bash-completion

%if_enabled check
BuildRequires: python3(sqlparse)
BuildRequires: python3(pytz)
BuildRequires: python3(sqlite3)
BuildRequires: python3(jinja2)
BuildRequires: python3(numpy)
BuildRequires: python3(pylibmc)
BuildRequires: python3(memcache)
BuildRequires: python3(yaml)
BuildRequires: python3(selenium)
%endif

%description
%summary

%package dbbackend-mysql
Summary: MySQLSQL support for Django (Python 3)
Group: Development/Python3
Requires: %name = %EVR
Provides: %name%branch-dbbackend-mysql = %EVR
Obsoletes: %name%branch-dbbackend-mysql < %EVR
Conflicts: python3-module-django1.11-dbbackend-mysql
%py3_requires MySQLdb

%description dbbackend-mysql
%summary

%package dbbackend-psycopg
Summary: PostgreSQL support for Django. (via psycopg) (Python 3)
Group: Development/Python3
Requires: %name = %EVR
Provides: %name%branch-dbbackend-psycopg = %EVR
Obsoletes: %name%branch-dbbackend-psycopg < %EVR
Conflicts: python3-module-django1.11-dbbackend-psycopg
%py3_requires psycopg

%description dbbackend-psycopg
%summary

%package dbbackend-psycopg2
Summary: PostgreSQL support for Django. (via psycopg2) (Python 3)
Group: Development/Python3
Requires: %name = %EVR
Provides: %name%branch-dbbackend-psycopg2 = %EVR
Obsoletes: %name%branch-dbbackend-psycopg2 < %EVR
Conflicts: python3-module-django1.11-dbbackend-psycopg2
%py3_requires psycopg2

%description dbbackend-psycopg2
%summary

%package dbbackend-sqlite3
Summary: SQLite3 support for Django (Python 3)
Group: Development/Python3
Requires: %name = %EVR
Provides: %name%branch-dbbackend-sqlite3 = %EVR
Obsoletes: %name%branch-dbbackend-sqlite3 < %EVR
Conflicts: python3-module-django1.11-dbbackend-sqlite3
%py3_requires sqlite3

%description dbbackend-sqlite3
%summary

%package doc
Summary: Django documentation
Group: Development/Python3
Provides: %name%branch-doc = %EVR
Obsoletes: %name%branch-doc < %EVR
Conflicts: python3-module-django1.11-doc

%description doc
%summary

%prep
%setup -n %origname-%version

# Use system six instead of bundled
find -type f -name '*.py*' -exec sed -i 's|django.utils.six|six|'  -- '{}' +

find -type f -name '*.py*' -exec sed -i 's|%_bindir/env python|%_bindir/python3|' -- '{}' +
find -type f -name '*.py' -exec sed -i 's|.*from future_builtins import zip.*||' -- '{}' +

%build
%python3_build

%install
export LC_ALL=en_US.UTF-8
%python3_install

# install man pages (for the main executable only)
mkdir -p %buildroot%_man1dir
cp -p docs/man/* %buildroot%_man1dir

# install bash completion script
bashcompdir=$(pkg-config --variable=completionsdir bash-completion)
mkdir -p %{buildroot}$bashcompdir
install -m 0644 -p extras/django_bash_completion \
  %{buildroot}$bashcompdir/django-admin

ln -s django-admin %{buildroot}$bashcompdir/django-admin-3
ln -s django-admin %{buildroot}$bashcompdir/python3-django-admin

# Add backward compatible links to %%{_bindir}
ln -s ./django-admin %buildroot%_bindir/django-admin-3
ln -s ./django-admin %buildroot%_bindir/python3-django-admin

# remove .po files
find %buildroot -name "*.po" | xargs rm -f

%check
export PYTHONPATH=$(pwd)
cd tests
LANG="en_US.UTF-8" python3 runtests.py --settings=test_sqlite --verbosity=2 --parallel 1

%files
%_bindir/*
%_man1dir/*
%_datadir/bash-completion/completions/*
%python3_sitelibdir/*
#exclude %python3_sitelibdir/%oname/core/handlers/modpython.py*
#exclude %python3_sitelibdir/%oname/contrib/auth/handlers/modpython.py*

%exclude %python3_sitelibdir/%oname/db/backends/mysql/
#exclude %python3_sitelibdir/%oname/db/backends/postgresql/
%exclude %python3_sitelibdir/%oname/db/backends/postgresql_psycopg2/
%exclude %python3_sitelibdir/%oname/db/backends/sqlite3/

%files doc
%doc docs

%files dbbackend-mysql
%python3_sitelibdir/%oname/db/backends/mysql

#files dbbackend-psycopg
#python3_sitelibdir/%oname/db/backends/postgresql

%files dbbackend-psycopg2
%python3_sitelibdir/%oname/db/backends/postgresql_psycopg2

%files dbbackend-sqlite3
%python3_sitelibdir/%oname/db/backends/sqlite3

%changelog
