%define _unpackaged_files_terminate_build 1

%define oname fabio

# check disabled because it relies a lot on network
%def_disable check

Name: python3-module-%oname
Version: 0.9.0
Release: alt2
Summary: Image IO for fable
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/fabio

# https://github.com/silx-kit/fabio.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: libnumpy-py3-devel python3-module-Cython
BuildRequires: python3(lxml)

# circumvent build failures due to relying on headers from libnumpy-devel
BuildRequires: libnumpy-devel

%add_python3_req_skip UserDict
%py3_requires argparse gzip six

%description
FabIO is an I/O library for images produced by 2D X-ray detectors and written in Python.
FabIO support images detectors from a dozen of companies (including Mar, Dectris, ADSC, Hamamatsu, Oxford, ...),
for a total of 20 different file formats (like CBF, EDF, TIFF, ...) and offers an unified interface to their
headers (as a python dictionary) and datasets (as a numpy ndarray of integers or floats).

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
FabIO is an I/O library for images produced by 2D X-ray detectors and written in Python.
FabIO support images detectors from a dozen of companies (including Mar, Dectris, ADSC, Hamamatsu, Oxford, ...),
for a total of 20 different file formats (like CBF, EDF, TIFF, ...) and offers an unified interface to their
headers (as a python dictionary) and datasets (as a numpy ndarray of integers or floats).

This package contains tests for %oname.

%prep
%setup

# remove some third-party bundled stuff
rm -rf fabio/third_party/_local

%build
%python3_build_debug

%install
%python3_install

%check
python3 setup.py test

%files
%doc README.rst
%_bindir/*
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%oname/test

%files tests
%python3_sitelibdir/%oname/test

%changelog
