%define oname kiwisolver
Name: python3-module-%oname
Version: 1.1.0
Release: alt1
Summary: A fast implementation of the Cassowary constraint solver
License: BSD
Group: Development/Python
Url: https://pypi.python.org/pypi/kiwisolver/
# VCS: https://github.com/nucleic/kiwi
Packager: Andrey Cherepanov <cas@altlinux.org>

# https://github.com/nucleic/kiwi.git
Source: kiwi-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools gcc-c++
BuildRequires: python3-dev

%description
Kiwi is an efficient C++ implementation of the Cassowary constraint
solving algorithm. Kiwi is an implementation of the algorithm based on
the seminal Cassowary paper. It is not a refactoring of the original C++
solver. Kiwi has been designed from the ground up to be lightweight and
fast. Kiwi ranges from 10x to 500x faster than the original Cassowary
solver with typical use cases gaining a 40x improvement. Memory savings
are consistently > 5x.

%prep
%setup -n kiwi-%version

%build
%python3_build

%install
%python3_install

%check
python3 setup.py test

%files
%doc *.rst
%python3_sitelibdir/*

%changelog
