%define qdoc_found %{expand:%%(if [ -e %_qt5_bindir/qdoc ]; then echo 1; else echo 0; fi)}
%global qt_module qtsvg

Name: qt5-svg
Version: 5.12.12
Release: alt1

Group: System/Libraries
Summary: Qt5 - Support for rendering and displaying SVG
Url: http://qt.io/
License: LGPLv2 / GPLv3

Source: %qt_module-everywhere-src-%version.tar

BuildRequires(pre): rpm-build-ubt rpm-macros-qt5 qt5-tools
BuildRequires: gcc-c++ glibc-devel qt5-base-devel > 5.5.0-alt3 pkgconfig(zlib)

%description
Scalable Vector Graphics (SVG) is an XML-based language for describing
two-dimensional vector graphics. Qt provides classes for rendering and
displaying SVG drawings in widgets and on other paint devices.

%package common
Summary: Common package for %name
Group: System/Configuration/Other
BuildArch: noarch
Requires: qt5-base-common
%description common
Common package for %name

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %EVR
Requires: qt5-base-devel
%description devel
%summary.

%package devel-static
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %EVR
Requires: %name-devel
%description devel-static
%summary.

%package doc
Summary: Document for developing apps which will use Qt5 %qt_module
Group: Development/KDE and QT
Requires: %name-common = %EVR
%description doc
This package contains documentation for Qt5 %qt_module

%package -n libqt5-svg
Summary: Qt5 library
Group: System/Libraries
Requires: %name-common = %EVR
Requires: libqt5-core = %_qt5_version
Provides: %name = %EVR
%description -n libqt5-svg
%summary

%prep
%setup -n %qt_module-everywhere-src-%version

%build
%qmake_qt5
%make_build
%if %qdoc_found
export QT_HASH_SEED=0
%make docs
%endif

%install
%install_qt5
%if %qdoc_found
%make INSTALL_ROOT=%buildroot install_docs ||:
%endif


%files common
%files -n libqt5-svg
%doc LICENSE*EXCEPT*
%_qt5_libdir/libQt?Svg.so.*
%_qt5_plugindir/iconengines/libqsvgicon.so
%_qt5_plugindir/imageformats/libqsvg.so

%files devel
%_qt5_headerdir/QtSvg/
%_qt5_libdir/lib*.so
%_qt5_libdir/lib*.prl
%_qt5_libdatadir/lib*.so
%_qt5_libdatadir/lib*.prl
%_qt5_libdir/cmake/Qt?Svg/
#%_qt5_libdir/cmake/Qt?Gui/*
%_qt5_libdir/pkgconfig/Qt5Svg.pc
%_qt5_archdatadir/mkspecs/modules/qt_lib_svg*.pri

%files doc
%if %qdoc_found
%_qt5_docdir/*
%endif
%_qt5_examplesdir/*

%changelog
