# vim: set ft=spec: -*- rpm-spec -*-
%define        pkgname rest-client

Summary:       Simple REST client for Ruby
Name:          ruby-%pkgname
Version:       2.1.0
Release:       alt1
Group:         Development/Ruby
License:       MIT
Url:           http://github.com/archiloque/rest-client
%vcs           http://github.com/archiloque/rest-client.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby

%add_findreq_skiplist %ruby_gemslibdir/**/*

%description
A simple Simple HTTP and REST client for Ruby, inspired by the Sinatra
microframework style of specifying actions: get, put, post, delete.


%package       -n restclient
Summary:       Executable file for %gemname gem
Summary(ru_RU.UTF-8): Исполнямка для самоцвета %gemname
Group:         Development/Ruby
BuildArch:     noarch

%description   -n restclient
Executable file for %gemname gem.

%description   -n restclient -l ru_RU.UTF8
Исполнямка для %gemname самоцвета.


%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%prep
%setup

%build
%ruby_build --use=%gemname --alias=restclient

%install
%ruby_install

%check
%ruby_test

%files
%doc README*
%ruby_gemspec
%ruby_gemlibdir

%files         -n restclient
%_bindir/restclient

%files         doc
%ruby_gemdocdir


%changelog
