
%define _libexecdir %prefix/libexec
%add_findreq_skiplist %_datadir/sddm/scripts/Xsession

%define sddm_user sddm
%define x11confdir %_sysconfdir/X11
%define sddm_confdir %x11confdir/sddm

Name: sddm
Version: 0.18.1
Release: alt11
%K5init no_altplace man

Group: Graphical desktop/KDE
Summary: Lightweight QML-based display manager
Url: https://github.com/sddm/sddm
License: GPLv2+

Requires: xinitrc >= 2.4.43 xauth /usr/share/design/current
Requires: qt5-quickcontrols

Source: %name-%version.tar
Source1: sddm.conf
Source2: tmpfiles-sddm.conf
Source3: ru.ts
Source10: sddm.pam
Source11: sddm-autologin.pam
Source12: sddm-greeter.pam
Source20: Xsetup
Source21: Xstop
# upstream
Patch1: CVE-2020-28049.patch
Patch2: nvidia-after-vt-switching.patch
# SuSE
Patch10: create_pid_file.patch
# github issues
# ALT
Patch100: alt-defaults.patch
Patch101: alt-branding-faces.patch
Patch102: alt-wmsession.patch
Patch103: alt-systemctl-path.patch
Patch104: alt-fix-desktop-session-name.patch
Patch105: alt-branding-background.patch
Patch106: alt-systemd-unit.patch
Patch107: alt-def-breeze.patch
Patch108: alt-show-avatars.patch
Patch109: alt-expired-password-handling.patch
Patch110: alt-sddm-etc.locale.conf.patch
Patch111: alt-sddm-ignore-locales.patch
Patch112: alt-sddm-etc.sysconfig.i18n.patch
Patch113: alt-sddm-greeter-swbackend.patch
Patch114: alt-detect-keyboard.patch
#
Patch200: alt-fix-unable-handle-request.patch
Patch201: alt-new-breeze-theme-compat.patch
Patch202: alt-dbus-sessionchange.patch
Patch203: alt-sddm-fix-pw-do-not-match.patch
Patch204: alt-sddm-visual-fixes.patch
Patch205: alt-smartcard-pin-login.patch
Patch206: alt-renew-font-color.patch
Patch207: alt-translate-renew-dialog.patch

# Automatically added by buildreq on Thu Apr 02 2015 (-bi)
# optimized out: cmake-modules elfutils libEGL-devel libGL-devel libcloog-isl4 libqt5-core libqt5-dbus libqt5-gui libqt5-network libqt5-qml libqt5-quick libqt5-test libqt5-xml libstdc++-devel libxcb-devel pkg-config python-base python-module-BeautifulSoup python-module-PyStemmer python-module-Pygments python-module-google python-module-google-apputils python-module-matplotlib python-module-numpy python-module-pyExcelerator python-module-pyparsing python-module-pytz python-module-setuptools python-module-snowballstemmer python-module-zope.interface python-modules python-modules-compiler python-modules-email python-modules-encodings qt5-base-devel qt5-tools
#BuildRequires: cmake gcc-c++ glibc-devel-static libpam-devel libsystemd-devel nss-ldapd python-module-Reportlab python-module-cssselect python-module-docutils python-module-ecdsa python-module-ed25519 python-module-html5lib python-module-nss python-module-polib python-module-protobuf python-module-pycparser python-module-pycrypto python-module-pygobject3 python-module-pygraphviz python-module-xlwt qt5-declarative-devel qt5-tools-devel ruby ruby-stdlibs time xsetroot
BuildRequires(pre): rpm-build-kf5 rpm-build-ubt
BuildRequires: cmake extra-cmake-modules glibc-devel
BuildRequires: libpam-devel libsystemd-devel libudev-devel
BuildRequires: libxcb-devel libXau-devel libXdmcp-devel
BuildRequires: qt5-declarative-devel qt5-tools-devel
BuildRequires: python3-module-docutils

%description
SDDM is a modern display manager for X11 aiming to be fast, simple and beatiful.
It uses modern technologies like QtQuick, which in turn gives the designer the
ability to create smooth, animated user interfaces.


%prep
%setup -n %name-%version
%patch1 -p1
%patch2 -p1
#
%patch10 -p1
#
%patch100 -p1 -b .defaults
#%patch101 -p1
%patch102 -p1 -b .wmsession
%patch103 -p1
%patch104 -p1
%patch105 -p1
%patch106 -p1
%patch107 -p1
%patch108 -p1
%patch109 -p1
%patch110 -p1
%patch111 -p1
%patch112 -p1
%patch113 -p1 -b .software_render
#%patch114 -p1 -b .detect_keyboard

%patch200 -p1
%patch201 -p1
%patch202 -p1
%patch203 -p2
%patch204 -p1
%patch205 -p3
%patch206 -p1
%patch207 -p1

sed -i 's|rst2man2.py|rst2man.py3|' data/man/CMakeLists.txt

%build
%K5build \
    -DDATA_INSTALL_DIR=%_datadir/sddm \
    -DCMAKE_INSTALL_LIBEXECDIR=%_libexecdir/sddm \
    -DLIBEXEC_INSTALL_DIR=%_libexecdir/sddm \
    -DSYSTEMD_SYSTEM_UNIT_DIR=%_unitdir \
    -DENABLE_PAM:BOOL=ON \
    -DENABLE_JOURNALD=ON \
    -DMINIMUM_VT=1 \
    -DSESSION_COMMAND="/etc/X11/Xsession" \
    -DBUILD_MAN_PAGES=ON \
    -DSTATE_DIR="%_localstatedir/sddm" \
    -DRUNTIME_DIR="%_runtimedir/sddm" \
    -DPID_FILE="%_runtimedir/sddm.pid" \
    -DCONFIG_FILE="%sddm_confdir/sddm.conf" \
    -DCONFIG_DIR="%_sysconfdir/sddm.conf.d" \
    -DSYSTEM_CONFIG_DIR="%_datadir/sddm/conf.d" \
    -DQT_IMPORTS_DIR="%_qt5_qmldir" \
    -DDBUS_CONFIG_FILENAME="sddm_org.freedesktop.DisplayManager.conf" \
    -DUID_MIN=500 \
    -DUID_MAX=32000 \
    #

lconvert-qt5 -i data/translations/ru.ts %SOURCE3 -o data/translations/ru.ts.new
rm -f data/translations/ru.ts
mv data/translations/ru.ts{.new,}

%install
%K5install

install -Dm 0644 %SOURCE1 %buildroot/%sddm_confdir/sddm.conf
install -Dpm 0644 %SOURCE2 %buildroot/lib/tmpfiles.d/sddm.conf
install -d %buildroot/%_runtimedir/sddm
install -d %buildroot/%_localstatedir/sddm
install -d %buildroot/%_sysconfdir/sddm.conf.d
install -d %buildroot/%_datadir/sddm/conf.d

install -m 0755 %SOURCE20 %buildroot/%sddm_confdir/
install -m 0755 %SOURCE21 %buildroot/%sddm_confdir/
rm -f %buildroot/%_datadir/sddm/scripts/X*

install -p -m 0644 %SOURCE10 %buildroot%_sysconfdir/pam.d/sddm
install -p -m 0644 %SOURCE11 %buildroot%_sysconfdir/pam.d/sddm-autologin
#install -p -m 0644 %SOURCE12 %buildroot%_sysconfdir/pam.d/sddm-greeter

# create default theme
#cp -ar %buildroot/%_datadir/sddm/themes/maui %buildroot/%_datadir/sddm/themes/default
#sed -i 's|^background=.*|background=%_datadir/design/current/backgrounds/xdm.png|' %buildroot/%_datadir/sddm/themes/default/theme.conf
#sed -i 's|^\(Name=.*\)|\1 Default|' %buildroot/%_datadir/sddm/themes/default/metadata.desktop
#sed -i 's|^\(Description=.*\)|\1 Default|' %buildroot/%_datadir/sddm/themes/default/metadata.desktop

%pre
/usr/sbin/useradd -c 'SDDM service' -s /sbin/nologin -d %_localstatedir/sddm -r %sddm_user 2> /dev/null || :

%files
%doc docs/*.md ChangeLog LICENSE* README* CONTRIBUTORS
%dir %sddm_confdir
%dir %_sysconfdir/sddm.conf.d/
%config(noreplace) %sddm_confdir/*
%config(noreplace) %_sysconfdir/pam.d/sddm*
%config(noreplace) %_sysconfdir/dbus-1/system.d/sddm_org.freedesktop.DisplayManager.conf
%_libexecdir/sddm/
%_bindir/sddm
%_bindir/sddm-greeter
%_K5qml/*
%_datadir/sddm/
%_man1dir/*.*
%_man5dir/*.*
%attr(0711,root,%sddm_user) %dir %_runtimedir/sddm
%attr(0775,%sddm_user,root) %dir %_localstatedir/sddm
%_unitdir/sddm.service
/lib/tmpfiles.d/sddm.conf

%changelog
