# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: soundconverter
Version: 3.0.2
Release: alt2.20200625

Summary: A simple sound converter application for GNOME
License: GPL-3.0-or-later
Group: Sound

Url: https://github.com/kassoulet/soundconverter
Source: %name-%version.tar
Patch: drop-unity.patch

BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildRequires: intltool
BuildRequires: python3-devel
BuildRequires: python3-module-pygobject3
BuildRequires: gir(Gst) = 1.0
BuildRequires: desktop-file-utils
Requires: gst-plugins-ugly1.0
Requires: gst-plugins-good1.0
Requires: gst-plugins-base1.0
Requires: GConf

%description
A simple sound converter application for the GNOME environment.
It reads and writes anything the GStreamer library can.

%prep
%setup
%patch -p1

%build
mkdir -p m4
%autoreconf
%configure
%make_build

%install
%makeinstall_std
%find_lang %name

# remove unidentified locale
rm -fr %buildroot%_datadir/locale/sr@Latn/

desktop-file-install \
	--dir %buildroot%_desktopdir \
	%buildroot%_desktopdir/%name.desktop
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=Audio \
	--add-category=AudioVideoEditing \
	%buildroot%_desktopdir/soundconverter.desktop

%files -f %name.lang
%doc ChangeLog COPYING README
%doc %_man1dir/*
%_bindir/%name
%_libdir/%name
%_datadir/%name
%_datadir/metainfo/%name.appdata.xml
%_datadir/glib-2.0/schemas/*
%_desktopdir/*%name.desktop
%_iconsdir/hicolor/48x48/apps/*.png
%_iconsdir/hicolor/scalable/apps/*.svg

%changelog
