%def_enable snapshot

%define ver_major 2.1
# no rules to make shared libudffs now
%def_disable shared

Name: udftools
Version: %ver_major
Release: alt1

Summary: Linux tools for UDF filesystems and DVD/CD-R(W) drives
Group: Archiving/Cd burning
License: %gpl2plus
Url: https://github.com/pali/udftools

%if_disabled snapshot
Source: %url/releases/download/%ver_major/%name-%version.tar.gz
%else
# VCS: https://github.com/pali/udftools.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch
%endif

BuildRequires(pre): rpm-build-licenses
BuildRequires: libudev-devel libncurses-devel libreadline-devel

%description
%name includes:
- mkudffs (mkfs.udf) is a tool to create a UDF (Universal Disk Format)
  filesystem   on a device.
- pktsetup to associate packet devices with CD or DVD block devices, so
  that the packet device can then be mounted and potentially used as a
  read/write filesystem. This requires kernel support for the packet
  device, and the UDF filesystem.
- cdwrtool tool that can perform certain actions on a CD-R, CD-RW, or
  DVD-R device. Mainly these are blanking the media, formating it for
  use with the packet-cd device, and applying an UDF filesystem.
- wrudf to maintain a UDF filesystem
- udfinfo which shows various information about UDF (incuding label,
  uuid, free space).
- udflabel which shows or changes UDF label or UDF uuid.

%prep
%setup
%patch -p1

%build
%autoreconf
%configure %{subst_enable shared}
%make_build

%install
%makeinstall_std

%files
%_bindir/cdrwtool
%_bindir/udfinfo
%_bindir/wrudf
%_sbindir/mkfs.udf
%_sbindir/mkudffs
%_sbindir/pktsetup
%_sbindir/udflabel
%_udevrulesdir/80-pktsetup.rules
%_man1dir/*
%_man8dir/*
%{?_enable_shared:%_libdir/*.so.*}
%doc AUTHORS NEWS README
%doc doc/HOWTO.udf doc/UDF-Specifications

%exclude %_datadir/doc/%name/

%changelog
