Name:		viking
Version:	1.7.0
Release:	alt3

Summary:	GPS data editor and analyzer

Group:		Sciences/Geosciences
License:	GPL-2.0-or-later
URL:		http://sourceforge.net/projects/viking/
Source0:	%{name}-%{version}.tar

BuildRequires: libcurl-devel libexpat-devel libgps-devel perl-XML-Parser intltool
BuildRequires: gnome-doc-utils libgtk+2-devel gtk-doc libgexiv2-devel libmagic-devel
BuildRequires: zlib-devel bzlib-devel libzip-devel
BuildRequires: libsqlite3-devel
BuildRequires: libgeoclue2-devel
BuildRequires: liboauth-devel
BuildRequires: libnettle-devel

Packager: Anton V. Boyarshinov <boyarsh@altlinux.ru>

%description
Viking is a free/open source program to manage GPS data. You can import and
plot tracks and waypoints, show Terraserver maps under it, add coordinate
lines, make new tracks and waypoints, hide different things, etc. It is written
in C with the GTK+ 2.

%prep
%setup -q

patch -p1 < gps_api_9_support.patch

%build
ln -s /usr/share/gnome-doc-utils/gnome-doc-utils.make
%autoreconf
%add_optflags -I/usr/include/libzip
%configure --disable-mapnik --enable-geocaches
%make

%install
%makeinstall
find %buildroot/usr/share/gnome/help/viking/ -type l -delete

#warning: Installed (but unpackaged) file(s) found:
rm -f %buildroot/usr/share/icons/hicolor/icon-theme.cache

#hack for fix https://bugzilla.altlinux.org/37674
pushd po
make install DESTDIR=%buildroot
popd

%find_lang %name

%check
make check

%files -f %name.lang
%doc AUTHORS ChangeLog COPYING NEWS README TODO doc/
%_bindir/viking
%_man1dir/*
%_datadir/applications/viking.desktop
%_iconsdir/hicolor/48x48/apps/viking.png
%_datadir/gnome/help/viking
%_datadir/omf/viking
%_datadir/viking

%changelog
