Name: xfce4-sensors-plugin
Version: 1.4.1
Release: alt2

Summary: Sensors plugin for Xfce Desktop
License: GPLv2+
Group: Graphical desktop/XFce
Url: https://docs.xfce.org/panel-plugins/xfce4-sensors-plugin
Packager: Xfce Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/panel-plugins/xfce4-sensors-plugin.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

%ifarch %ix86 x86_64
%def_enable xnvctrl
%else
%def_disable xnvctrl
%endif

BuildPreReq: rpm-build-xfce4 xfce4-dev-tools
BuildPreReq: libxfce4panel-gtk3-devel libxfce4ui-gtk3-devel libxfce4util-devel
BuildRequires: hddtemp intltool libsensors3-devel libnotify-devel
%{?_enable_xnvctrl:BuildRequires: nvidia-settings-devel}

Requires: xfce4-panel >= 4.11 hddtemp lm_sensors3

%define _unpackaged_files_terminate_build 1

%description
%name

%prep
%setup
%patch -p1
# Don't use git tag in version.
%xfce4_drop_gitvtag xfce4_sensors_version_tag configure.ac.in

%build
%xfce4reconf
%configure \
    --disable-static \
    --enable-hddtemp=yes \
    --disable-netcat \
    --enable-libsensors=yes \
    --enable-procacpi \
    --enable-sysfsacpi \
    %{subst_enable xnvctrl} \
    --enable-notification \
    --enable-debug=minimum
%make_build

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%doc NEWS AUTHORS
%_bindir/*
%_desktopdir/*.desktop
%_iconsdir/*/*/*/*
%_libdir/xfce4/panel/plugins/*.so
%_libdir/xfce4/modules/libxfce4sensors.so*
%_liconsdir/*.png
%_datadir/xfce4/panel/plugins/*.desktop
%_datadir/xfce4/panel/plugins/%name.css
%_man1dir/xfce4-sensors.1*
%exclude %_pkgconfigdir/*.pc
%exclude %_libdir/xfce4/modules/libxfce4sensors.la
%exclude %_libdir/xfce4/panel/plugins/*.la

%changelog
