Name: Kvantum
Version: 0.19.0
Release: alt1

Summary: SVG-based theme engine for Qt5, KDE and LXQt
License: GPL-3.0-or-later
Group: Graphical desktop/Other

Url: https://github.com/tsujan/Kvantum
# Source-url: https://github.com/tsujan/Kvantum/archive/V%version.tar.gz
Source: %name-%version.tar.gz
Packager: Leontiy Volodin <lvol@altlinux.org>

BuildRequires(pre): rpm-build-ninja
BuildRequires: gcc-c++ cmake libX11-devel libXext-devel libqt4-devel qt5-base-devel qt5-tools-devel qt5-svg-devel qt5-x11extras-devel kf5-kwindowsystem-devel desktop-file-utils icon-theme-hicolor
Requires: %name-data

%description
Kvantum is an SVG-based theme engine for Qt5, KDE and LXQt, with an emphasis
on elegance, usability and practicality.

Kvantum has a default dark theme, which is inspired by the default theme of
Enlightenment. Creation of realistic themes like that for KDE was the first
reason to make Kvantum but it goes far beyond its default theme: you could
make themes with very different looks and feels for it, whether they be
photorealistic or cartoonish, 3D or flat, embellished or minimalistic, or
something in between, and Kvantum will let you control almost every aspect of
Qt widgets.

Kvantum also comes with extra themes that are installed as root with Qt5
installation and can be selected and activated by using Kvantum Manager.

%package data
Summary: SVG-based theme engine for Qt5, KDE and LXQt
Group: Graphical desktop/Other
BuildArch: noarch

%description data
Kvantum is an SVG-based theme engine for Qt5, KDE and LXQt, with an emphasis
on elegance, usability and practicality.

This package contains the data needed for Kvantum.

%prep
%setup

%build
%ifarch %e2k
# -std=c++03 by default as of lcc 1.23.12
%add_optflags -std=c++11
%endif
%cmake_insource -GNinja
%ninja_build

%install
%ninja_install

# desktop-file-validate doesn't recognize LXQt
sed -i "s|LXQt|X-LXQt|" %buildroot%_desktopdir/kvantummanager.desktop
desktop-file-validate %buildroot%_desktopdir/kvantummanager.desktop

%find_lang %name --all-name --with-qt

%files
%doc COPYING
%doc ChangeLog NEWS README.md
%_bindir/kvantummanager
%_bindir/kvantumpreview
%_qt5_plugindir/styles/libkvantum.so

%files data -f %name.lang
%_datadir/Kvantum
%_desktopdir/kvantummanager.desktop
%dir %_datadir/kvantummanager
%dir %_datadir/kvantummanager/translations
%_datadir/kvantummanager/translations/kvantummanager_zh_Hant.qm
%dir %_datadir/kvantumpreview
%dir %_datadir/kvantumpreview/translations
%_datadir/kvantumpreview/translations/kvantumpreview_zh_Hant.qm
%dir %_datadir/color-schemes
%_datadir/color-schemes/Kv*
%dir %_iconsdir/hicolor/scalable
%dir %_iconsdir/hicolor/scalable/apps
%_iconsdir/hicolor/scalable/apps/kvantum.svg
%dir %_datadir/themes
%dir %_datadir/themes/Kv*
%_datadir/themes/Kv*/*

%changelog
