%def_enable egl
%def_enable gles2

%define dri_drivers_add() %{expand:%%global dri_drivers %{?dri_drivers:%dri_drivers,}%{1}}
%define gallium_drivers_add() %{expand:%%global gallium_drivers %{?gallium_drivers:%gallium_drivers,}%{1}}
%define vulkan_drivers_add() %{expand:%%global vulkan_drivers %{?vulkan_drivers:%vulkan_drivers,}%{1}}

%define radeon_arches %ix86 x86_64 aarch64 ppc64le mipsel
%define vulkan_radeon_arches %ix86 x86_64 ppc64le mipsel
%define nouveau_arches %ix86 x86_64 armh aarch64 ppc64le mipsel
%define intel_arches %ix86 x86_64
%define vulkan_intel_arches %ix86 x86_64
%define virgl_arches %ix86 x86_64 aarch64 ppc64le mipsel
%define armsoc_arches %arm aarch64
%define svga_arches %ix86 x86_64

%define opencl_arches %ix86 x86_64 aarch64
%define gallium_pipe_arches %ix86 x86_64 aarch64 mipsel

#VDPAU state tracker requires at least one of the following gallium drivers: r300, r600, radeonsi, nouveau
%define vdpau_arches %radeon_arches %nouveau_arches
#XVMC state tracker requires at least one of the following gallium drivers: r600, nouveau
%define xvmc_arches %radeon_arches %nouveau_arches
# Mesa builds radeon and nouveau support as megadrivers
%define dri_megadriver_arches %radeon_arches %nouveau_arches
%define gallium_megadriver_arches %radeon_arches %nouveau_arches
# XA state tracker requires at least one of the following gallium drivers: nouveau, freedreno, i915, svga
%define xa_arches %nouveau_arches %virgl_arches %armsoc_arches

%gallium_drivers_add swrast
%ifarch %radeon_arches
%dri_drivers_add r100
%dri_drivers_add r200
%gallium_drivers_add r300
%gallium_drivers_add r600
%gallium_drivers_add radeonsi
%endif
%ifarch %intel_arches
%dri_drivers_add i915
%dri_drivers_add i965
%gallium_drivers_add iris
%endif
%ifarch %nouveau_arches
%dri_drivers_add nouveau
%gallium_drivers_add nouveau
%endif
%ifarch %virgl_arches
%gallium_drivers_add virgl
%endif
%ifarch %armsoc_arches
%gallium_drivers_add vc4
%gallium_drivers_add etnaviv
%gallium_drivers_add freedreno
%gallium_drivers_add kmsro
%gallium_drivers_add panfrost
%gallium_drivers_add lima
%gallium_drivers_add tegra
%gallium_drivers_add v3d
%endif
%ifarch %svga_arches
%gallium_drivers_add svga
%endif
%ifarch %vulkan_intel_arches
%vulkan_drivers_add intel
%endif
%ifarch %vulkan_radeon_arches
%vulkan_drivers_add amd
%endif
%ifarch %armsoc_arches
%vulkan_drivers_add freedreno
%vulkan_drivers_add broadcom
%endif

Name: Mesa
Version: 21.0.3
Release: alt1
Epoch: 4
License: MIT
Summary: OpenGL compatible 3D graphics library
Group: System/Libraries
Url: http://www.mesa3d.org

Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source: %name-%version.tar
Patch: %name-%version.patch

BuildPreReq: /proc
BuildRequires(pre): meson
BuildRequires: gcc-c++ indent flex libXdamage-devel libXext-devel libXft-devel libXmu-devel libXi-devel libXrender-devel libXxf86vm-devel
BuildRequires: libdrm-devel libexpat-devel libselinux-devel libxcb-devel libSM-devel libtinfo-devel libudev-devel
BuildRequires: libXdmcp-devel libffi-devel libelf-devel libva-devel libvdpau-devel libXvMC-devel xorg-proto-devel libxshmfence-devel
BuildRequires: libXrandr-devel libnettle-devel libelf-devel zlib-devel libwayland-client-devel libwayland-server-devel
BuildRequires: libwayland-egl-devel python3-module-mako wayland-protocols libsensors-devel libzstd-devel libunwind-devel
BuildRequires: libclc-devel libglvnd-devel >= 1.2.0 llvm-devel >= 11.0.0 clang-devel >= 11.0.0

%description
Mesa is an OpenGL compatible 3D graphics library

%package -n libGLX-mesa
Summary: OpenGL 1.3 compatible 3D graphics library for X Window server
Group: System/Libraries
Conflicts: libGL < 4:19.2.2-alt1

%description -n libGLX-mesa
Mesa is an OpenGL compatible 3D graphics library

%package -n libGL-devel
Summary: Development files for Mesa Library
Group: Development/C
Requires: libglvnd-devel >= 1.2.0 libGLX-mesa = %epoch:%version-%release

%description -n libGL-devel
libGL-devel contains the libraries and header files needed to
develop programs which make use of Mesa

%package -n libEGL-mesa
Summary: Mesa EGL library
Group: System/Libraries

%description -n libEGL-mesa
Mesa EGL library

%package -n libEGL-devel
Summary: Mesa libEGL development package
Group: Development/C
Requires: libglvnd-devel >= 1.2.0

%description -n libEGL-devel
Mesa libEGL development package

%package -n libgbm
Summary: GBM buffer management library
Group: System/Libraries

%description -n libgbm
GBM buffer management library

%package -n libgbm-devel
Summary: GBM buffer management development package
Group: Development/C

%description -n libgbm-devel
GBM buffer management development package

%package -n libxatracker
Summary: Mesa XA state tracker
Group: System/Libraries

%description -n libxatracker
Xorg Gallium3D acceleration library

%package -n libxatracker-devel
Summary: Mesa XA state tracker development package
Group: Development/C

%description -n libxatracker-devel
Xorg Gallium3D acceleration development package

%package -n libMesaOpenCL
Summary: Mesa OpenCL runtime library
Group: System/Libraries
Requires: ocl-icd libclc

%description -n libMesaOpenCL
This package contains the mesa implementation of the OpenCL (Open Compute
Language) library, which is intended for use with an ICD loader. OpenCL
provides a standardized interface for computational analysis on graphical
processing units.

%package -n xorg-dri-swrast
Summary: Mesa software rendering libraries
Group: System/X11
Provides: xorg-dri-virgl
Obsoletes: xorg-dri-virgl < %epoch:%version-%release

%description -n xorg-dri-swrast
Mesa software rendering libraries

%package -n xorg-dri-intel
Summary: Intel DRI driver
Group: System/X11
Requires: libva-driver-intel
%ifarch x86_64
Requires: libva-intel-media-driver
%endif

%description -n xorg-dri-intel
DRI driver for Intel i8xx, i9xx

%package -n xorg-dri-radeon
Summary: ATI RADEON DRI driver
Group: System/X11
%ifarch %vdpau_arches
Requires: libvdpau
%endif

%description -n xorg-dri-radeon
DRI driver for ATI R100, R200, R300, R400, R500

%package -n xorg-dri-nouveau
Summary: nVidia DRI driver
Group: System/X11
%ifarch %vdpau_arches
Requires: libvdpau
%endif

%description -n xorg-dri-nouveau
DRI driver for nVidia

%package -n xorg-dri-vmwgfx
Summary: VMWare DRI driver
Group: System/X11

%description -n xorg-dri-vmwgfx
DRI driver for VMWare

%package -n xorg-dri-armsoc
Summary: SoC DRI drivers
Group: System/X11

%description -n xorg-dri-armsoc
DRI drivers for various SoCs

%package -n mesa-dri-drivers
Summary: Mesa-based DRI drivers
Group: System/X11
%ifarch %vulkan_radeon_arches
Provides: mesa-vulkan-drivers = %epoch:%version-%release
%endif
%ifarch %vdpau_arches
Provides: mesa-vdpau-drivers = %epoch:%version-%release
%endif
Requires: xorg-dri-swrast = %epoch:%version-%release
%ifarch %radeon_arches
Requires: xorg-dri-radeon = %epoch:%version-%release
%endif
%ifarch %nouveau_arches
Requires: xorg-dri-nouveau = %epoch:%version-%release
%endif
%ifarch %intel_arches
Requires: xorg-dri-intel = %epoch:%version-%release
%endif
%ifarch %armsoc_arches
Requires: xorg-dri-armsoc = %epoch:%version-%release
%endif
%ifarch %svga_arches
Requires: xorg-dri-vmwgfx = %epoch:%version-%release
%endif

%description -n mesa-dri-drivers
Mesa-based DRI drivers

%set_verify_elf_method unresolved=relaxed

%prep
%setup -q
%patch -p1

%build
%meson \
	-Dplatforms=x11,wayland \
	-Ddri-drivers='%{?dri_drivers}' \
	-Dgallium-drivers='%{?gallium_drivers}' \
	-Dvulkan-drivers='%{?vulkan_drivers}' \
%ifarch %vdpau_arches
	-Dgallium-vdpau=true \
%endif
%ifarch %xvmc_arches
	-Dgallium-xvmc=true \
%endif
	-Ddri3=true \
%ifarch %opencl_arches
	-Dgallium-opencl=icd \
%endif
%ifarch %radeon_arches
	-Dllvm=enabled \
	-Dshared-llvm=enabled \
%endif
	-Dshared-glapi=true \
%if_enabled egl
	-Degl=true \
%else
	-Degl=false \
%endif
%if_enabled gles2
	-Dgles2=true \
%else
	-Dgles2=false \
%endif
%ifarch %xa_arches
	-Dgallium-xa=true \
%else
	-Dgallium-xa=false \
%endif
%ifarch armh
	-Dlibunwind=false \
%endif
	-Dgles1=false \
	-Dopengl=true \
	-Dselinux=true \
	-Dglvnd=true \
	-Ddri-drivers-path=%_libdir/X11/modules/dri \
#

%meson_build -v

%install
%meson_install

mkdir -p %buildroot%_sysconfdir
touch %buildroot%_sysconfdir/drirc
rm -f %buildroot%_libdir/gallium-pipe/*.la

shopt -s nullglob
m="%buildroot%_libdir/X11/modules/dri %buildroot%_libdir/dri"
for d in $m; do
	for f in $d/*.so; do
		[ ! -L "$f" ] || continue
		n="${f##*/}"
		s="$(objdump -p "$f" | awk '/SONAME/ {print $2}')"
		[ -n "$s" ]
		[ "$n" != "$s" ] || continue
		t="$d/$s"
		[ -f "$t" ] || mv "$f" "$t"
		ln -v -snf "${t##*/}" "$f"
	done
done
d=%buildroot%_libdir/vdpau
	for f in $d/*.so.1.0.0; do
                [ ! -L "$f" ] || continue
                n="${f##*/}"
                s="$(objdump -p "$f" | awk '/SONAME/ {print $2}')"
                [ -n "$s" ]
                [ "$n" != "$s" ] || continue
                t="$d/$s"
                [ -f "$t" ] || mv "$f" "$t"
                ln -v -snf "${t##*/}" "$f"
        done
d=%buildroot%_libdir
	for f in $d/libXvMC*.so.1.0.0; do
                [ ! -L "$f" ] || continue
                n="${f##*/}"
                s="$(objdump -p "$f" | awk '/SONAME/ {print $2}')"
                [ -n "$s" ]
                [ "$n" != "$s" ] || continue
                t="$d/$s"
                [ -f "$t" ] || mv "$f" "$t"
                ln -v -snf "${t##*/}" "$f"
        done

%ifarch %armsoc_arches
find %buildroot%_libdir/X11/modules/dri/ -type l | sed -ne "s|^%buildroot||p" > xorg-dri-armsoc.list
%ifarch %gallium_pipe_arches
find %buildroot%_libdir/gallium-pipe/ -type f | sed -ne "s|^%buildroot||p" >> xorg-dri-armsoc.list
sed -i '/.*pipe_r[a236].*/d' xorg-dri-armsoc.list
%endif
sed -i '/.*swrast.*/d' xorg-dri-armsoc.list
sed -i '/.*virtio.*/d' xorg-dri-armsoc.list
sed -i '/.*nouveau.*/d' xorg-dri-armsoc.list
sed -i '/.*dri\/r[a236].*/d' xorg-dri-armsoc.list
%endif

#define _unpackaged_files_terminate_build 1

%files -n libGLX-mesa
%doc docs/relnotes/%version.rst
%_libdir/libGLX_mesa.so.*
%_libdir/libglapi.so.*

%files -n libGL-devel
%_includedir/GL/internal
%_libdir/libGLX_mesa.so
%_libdir/libglapi.so
%_pkgconfigdir/dri.pc

%if_enabled egl
%files -n libEGL-mesa
%_libdir/libEGL_mesa.so.*
%_datadir/glvnd/egl_vendor.d/50_mesa.json

%files -n libEGL-devel
%_includedir/EGL/eglextchromium.h
%_includedir/EGL/eglmesaext.h
%_libdir/libEGL_mesa.so
%endif

%files -n libgbm
%_libdir/libgbm.so.*

%files -n libgbm-devel
%_includedir/gbm.h
%_libdir/libgbm.so
%_pkgconfigdir/gbm.pc

%ifarch %xa_arches
%files -n libxatracker
%_libdir/libxatracker.so.*

%files -n libxatracker-devel
%_includedir/xa_*.h
%_libdir/libxatracker.so
%_pkgconfigdir/xatracker.pc
%endif

%ifarch %opencl_arches
%files -n libMesaOpenCL
%dir %_sysconfdir/OpenCL
%dir %_sysconfdir/OpenCL/vendors
%_sysconfdir/OpenCL/vendors/mesa.icd
%_libdir/libMesaOpenCL.so.*
%endif

%files -n xorg-dri-swrast
%ghost %_sysconfdir/drirc
%_datadir/drirc.d
%_libdir/X11/modules/dri/*swrast*_dri.so
%_libdir/X11/modules/dri/libgallium_dri.so
%ifarch %dri_megadriver_arches
%_libdir/X11/modules/dri/libmesa_dri_drivers.so
%endif
%ifarch %virgl_arches
%_libdir/X11/modules/dri/virtio_gpu_dri.so
%endif
%ifarch %gallium_pipe_arches
%dir %_libdir/gallium-pipe
%_libdir/gallium-pipe/pipe_swrast.so
%endif
%ifarch %gallium_megadriver_arches
%_libdir/libXvMCgallium.so.1
%_libdir/dri/libgallium_drv_video.so
%endif
%ifarch %vdpau_arches
%_libdir/vdpau/libvdpau_gallium.so.1.0.0
%endif

%ifarch %intel_arches
%files -n xorg-dri-intel
%_libdir/X11/modules/dri/i9?5_dri.so
%_libdir/X11/modules/dri/iris_dri.so
%ifarch %vulkan_intel_arches
%_libdir/libvulkan_intel.so
%dir %_datadir/vulkan
%dir %_datadir/vulkan/icd.d
%_datadir/vulkan/icd.d/intel_icd*.json
%ifarch %gallium_pipe_arches
%_libdir/gallium-pipe/pipe_iris.so
%endif
%endif
%endif

%ifarch %nouveau_arches
%files -n xorg-dri-nouveau
%_libdir/X11/modules/dri/nouveau_*dri.so
%_libdir/dri/nouveau_drv_video.so
%_libdir/vdpau/libvdpau_nouveau.so*
%_libdir/libXvMCnouveau.so.*
%ifarch %gallium_pipe_arches
%_libdir/gallium-pipe/pipe_nouveau.so
%endif
%endif

%ifarch %radeon_arches
%files -n xorg-dri-radeon
%_libdir/X11/modules/dri/radeon*_dri.so
%_libdir/X11/modules/dri/r?00_dri.so
%_libdir/vdpau/libvdpau_r*.so*
%_libdir/dri/r*_drv_video.so
%_libdir/libXvMCr*.so.*
%ifarch %gallium_pipe_arches
%_libdir/gallium-pipe/pipe_r*.so
%endif
%ifarch %vulkan_radeon_arches
%_libdir/libvulkan_radeon.so
%dir %_datadir/vulkan
%dir %_datadir/vulkan/icd.d
%_datadir/vulkan/icd.d/radeon_icd*.json
%endif
%endif

%ifarch %svga_arches
%files -n xorg-dri-vmwgfx
%_libdir/X11/modules/dri/vmwgfx_dri.so
%_libdir/gallium-pipe/pipe_vmwgfx.so
%endif

%ifarch %armsoc_arches
%files -n xorg-dri-armsoc -f xorg-dri-armsoc.list
%_libdir/libvulkan_freedreno.so
%_libdir/libvulkan_broadcom.so
%dir %_datadir/vulkan
%dir %_datadir/vulkan/icd.d
%_datadir/vulkan/icd.d/freedreno_icd*.json
%_datadir/vulkan/icd.d/broadcom_icd*.json
%endif

%files -n mesa-dri-drivers

%changelog
