%define nm_version 1.1.90
%define nm_applet_version 1.1.90
%define nm_applet_name NetworkManager-applet-gtk
#define git_date .git20170115
%define git_date %nil
%define ppp_version 2.4.7

%def_without libnm_glib

%define _unpackaged_files_terminate_build 1

Name: NetworkManager-l2tp
Version: 1.2.12
Release: alt2%git_date
License: GPLv2+
Group: System/Configuration/Networking
Summary:  NetworkManager VPN plugin for l2tp
Url: https://networkmanager.dev/docs/vpn/
Vcs: git://github.com/nm-l2tp/NetworkManager-l2tp.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch
Requires: NetworkManager-daemon >= %nm_version
Requires: NetworkManager-ppp >= %nm_version
Requires: xl2tpd
Requires: ppp = %ppp_version

Requires: strongswan

BuildRequires: ppp-devel
BuildRequires: libnm-devel >= %nm_version
BuildRequires: libnma-devel >= %nm_applet_version
%if_with libnm_glib
BuildRequires: NetworkManager-devel >= %nm_version
BuildRequires: libnm-glib-vpn-devel >= %nm_version
BuildRequires: libnm-gtk-devel >= %nm_applet_version
%endif
BuildRequires: libgtk+3-devel
BuildRequires: libsecret-devel
BuildRequires: intltool gettext

%description
This package contains software for integrating the l2tp VPN software
with NetworkManager.

%package gtk
License: GPLv2+
Summary: Applications for use %name with %nm_applet_name
Group: Graphical desktop/GNOME
Requires: %nm_applet_name >= %nm_applet_version
Requires: NetworkManager-l2tp = %version-%release

Obsoletes: %name-gnome < 0.9.8-alt2
Provides: %name-gnome = %version-%release

%description gtk
This package contains GNOME applications for use with
NetworkManager panel applet.

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	--disable-static \
	--libexecdir=%_libexecdir/NetworkManager \
	--localstatedir=%_var \
	--with-pppd-plugin-dir=%_libdir/pppd/%ppp_version \
%if_without libnm_glib
	--without-libnm-glib \
%endif
	--with-nm-ipsec-secrets=/etc/strongswan/ipsec.secrets \
	--with-nm-ipsec-secrets-dir=/etc/strongswan/ipsec.d \
	--disable-silent-rules \
	--enable-more-warnings=yes
%make_build

%install
%makeinstall_std
%find_lang %name

%files
%doc AUTHORS
%config %_sysconfdir/dbus-1/system.d/nm-l2tp-service.conf
%_libexecdir/NetworkManager/nm-l2tp-service
%_libdir/pppd/%ppp_version/*.so
%if_with libnm_glib
%config %_sysconfdir/NetworkManager/VPN/nm-l2tp-service.name
%endif
%config %_libexecdir/NetworkManager/VPN/nm-l2tp-service.name

%files gtk -f %name.lang
%if_with libnm_glib
%_libdir/NetworkManager/libnm-l2tp-properties.so
%endif
%_libexecdir/NetworkManager/nm-l2tp-auth-dialog
%_libdir/NetworkManager/libnm-vpn-plugin-l2tp.so
%_libdir/NetworkManager/libnm-vpn-plugin-l2tp-editor.so
%_datadir/appdata/*.xml

%exclude %_libdir/NetworkManager/*.la
%exclude %_libdir/pppd/%ppp_version/*.la

%changelog
