%define nm_version 1.1.90
%define nm_applet_version 1.1.90
%define nm_applet_name NetworkManager-applet-gtk
%define git_date %nil
#define git_date .git20110314
%define ppp_version 2.4.7

%def_without libnm_glib

%define _unpackaged_files_terminate_build 1

%ifarch %e2k
%define more_warnings no
%else
%define more_warnings error
%endif

Name: NetworkManager-pptp
Version: 1.2.8
Release: alt1%git_date
License: %gpl2plus
Group: System/Configuration/Networking
Summary:  NetworkManager VPN plugin for pptp
Url: http://www.gnome.org/projects/NetworkManager/
# git://git.gnome.org/network-manager-pptp
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-licenses

BuildRequires: ppp-devel
BuildRequires: libnm-devel >= %nm_version
BuildRequires: libnma-devel >= %nm_applet_version
%if_with libnm_glib
BuildRequires: NetworkManager-devel >= %nm_version
BuildRequires: libnm-glib-vpn-devel >= %nm_version
BuildRequires: libnm-gtk-devel >= %nm_applet_version
%endif
BuildRequires: libgtk+3-devel
BuildRequires: libsecret-devel
BuildRequires: intltool gettext

Requires: NetworkManager-daemon   >= %nm_version
Requires: NetworkManager-ppp   >= %nm_version
Requires: pptp-client
Requires: ppp = %ppp_version

%description
This package contains software for integrating the pptp VPN software
with NetworkManager.

%package gtk
License: %gpl2plus
Summary: Applications for use %name with %nm_applet_name
Group: Graphical desktop/GNOME
Requires: %nm_applet_name >= %nm_applet_version
Requires: NetworkManager-pptp = %version-%release

Obsoletes: %name-gnome < 0.9.8.4
Provides: %name-gnome = %version-%release

%description gtk
This package contains applications for use with
NetworkManager panel applet.

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	--disable-static \
	--libexecdir=%_libexecdir/NetworkManager \
	--localstatedir=%_var \
	--with-pppd-plugin-dir=%_libdir/pppd/%ppp_version \
%if_without libnm_glib
	--without-libnm-glib \
%endif
	--enable-more-warnings=%more_warnings
%make_build

%install
%makeinstall_std
%find_lang %name

%files
%doc AUTHORS
%config %_sysconfdir/dbus-1/system.d/nm-pptp-service.conf
%_libexecdir/NetworkManager/nm-pptp-service
%_libdir/NetworkManager/libnm-vpn-plugin-pptp.so
%_libdir/pppd/%ppp_version/*.so
%if_with libnm_glib
%config %_sysconfdir/NetworkManager/VPN/nm-pptp-service.name
%endif
%config %_libexecdir/NetworkManager/VPN/nm-pptp-service.name

%files gtk -f %name.lang
%if_with libnm_glib
%_libdir/NetworkManager/libnm-pptp-properties.so
%endif
%_libexecdir/NetworkManager/nm-pptp-auth-dialog
%_libdir/NetworkManager/libnm-vpn-plugin-pptp-editor.so
%_datadir/appdata/*.xml

%exclude %_libdir/NetworkManager/*.la
%exclude %_libdir/pppd/%ppp_version/*.la

%changelog
