%def_enable snapshot
%define ver_major 2.14
%def_disable static
%def_enable gtk_doc

Name: ORBit2
Version: %ver_major.20
Release: alt0.3

Summary: A high-performance CORBA Object Request Broker
Group: System/Libraries
License: %gpl2plus
Url: http://www.gnome.org/projects/%name

Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.bz2
%else
#VCS: https://gitlab.gnome.org/Archive/orbit2.git
Source: %name-%version.tar
%endif
Patch: %name-2.7.3-alt-test_makefile.patch
Patch1: %name-2.14.20-alt-shared_name-server.patch
Patch2: %name-2.13.3-fix-link-as-needed.patch
Patch3: %name-2.14.20-alt-fix-include-in-makefile.patch

%define libIDL_ver 0.8.2
%define glib_ver 2.8.0
%define pkgconfig_ver 0.18

Requires: lib%name = %version-%release

BuildPreReq: rpm-build-licenses rpm-build-gnome
BuildPreReq: pkgconfig >= %pkgconfig_ver
BuildPreReq: libIDL-devel >= %libIDL_ver
BuildPreReq: glib2-devel >= %glib_ver
BuildRequires: indent libssl-devel

%if_enabled gtk_doc
BuildRequires: docbook-dtds docbook-style-xsl gtk-doc xml-common xsltproc
%endif

%description
ORBit is a high-performance CORBA (Common Object Request Broker
Architecture) ORB (object request broker). It allows programs to send
requests and receive replies from other programs, regardless of the
locations of the two programs. CORBA is an architecture that enables
communication between program objects, regardless of the programming
language they're written in or the operating system they run on.

You will need to install this package and ORBit-devel if you want to
write programs that use CORBA technology.

%package -n lib%name
Summary: Shared libraries, header files and utilities for ORBit
Group: System/Libraries
License: %lgpl2plus

%description -n lib%name
ORBit is a high-performance CORBA (Common Object Request Broker
Architecture) ORB (object request broker). It allows programs to send
requests and receive replies from other programs, regardless of the
locations of the two programs. CORBA is an architecture that enables
communication between program objects, regardless of the programming
language they're written in or the operating system they run on.

This package contains the shared libraries required for ORBit
and components using it to function.

%package devel
Summary: Development libraries, header files and utilities for ORBit
Group: Development/GNOME and GTK+
License: %lgpl2plus
Requires: lib%name = %version-%release
#Requires: indent

%description devel
ORBit is a high-performance CORBA (Common Object Request Broker
Architecture) ORB (object request broker) with support for the C
language.

This package contains the header files, libraries and utilities
necessary to write programs that use CORBA technology. If you want to
write such programs, you'll also need to install the ORBit2 package.

%package devel-doc
Summary: Development documentation for ORBit
Group: Development/C
BuildArch: noarch
Conflicts: %name < %version-%release

%description devel-doc
ORBit is a high-performance CORBA (Common Object Request Broker
Architecture) ORB (object request broker) with support for the C
language.

This package contains development documentation for ORBit.

%if_enabled static
%package devel-static
Summary: Static libraries for ORBit2
Group: Development/GNOME and GTK+
Requires: %name-devel = %version-%release

%description devel-static
ORBit is a high-performance CORBA (Common Object Request Broker
Architecture) ORB (object request broker) with support for the C
language.

This package contains static versions of libraries from ORBit2 package.
%endif

%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup -q
%patch -p1 -b .test
%patch1 -p0 -b .shared_name-server
%patch2 -p0 -b .as_needed
%patch3 -p2 -b .include

%build
%autoreconf
%configure \
	%{subst_enable static} \
	%{?_enable_gtk_doc:--enable-gtk-doc}
# SMP-incompatible build
%make

%install
%makeinstall_std

# system orbitrc file
mkdir -p %buildroot%_sysconfdir
cat << EOF > %buildroot%_sysconfdir/orbitrc
## IIOP over IP server sockets disabled by default. Instead
## either UNIX domain sockets or shared memory for interprocess
## communication are used. This disables communcation over the network but
## prevents the system from Denial of Service attacks. If you want to use
## ORBit over the network you need to turn it on again (see
## http://orbit-resource.sourceforge.net/faq.html)

#ORBIIOPIPv4=1
#ORBLocalOnly=1
#ORBIIOPIPName=127.0.0.1
EOF

%check
%make check

%files
%_bindir/typelib-dump
%_bindir/linc-cleanup-sockets
%dir %_libdir/orbit-2.0
%_libdir/orbit-2.0/*.so
%_datadir/idl/*
%config %_sysconfdir/orbitrc
%doc AUTHORS NEWS README

%files -n lib%name
%_libdir/*.so.*

%files devel
%_bindir/orbit2-config
%_bindir/orbit-idl-2
%_bindir/ior-decode-2
%_libdir/*.so
%_pkgconfigdir/*
%_includedir/*
%_datadir/aclocal/*
%doc HACKING MAINTAINERS TODO

%files devel-doc
%_gtk_docdir/*

%if_enabled static
%files devel-static
%_libdir/*.a
%_libdir/*/*.a
%endif

%exclude %_libdir/*/*.la

%changelog
