Name: Pymacs
Version: 0.24
Release: alt1beta2.2

Summary: Two-way communication between Python and Emacs
Source: %name-%version.tar
License: GPL
Group: Development/Python
Requires: python
Requires: emacs
Url: http://pymacs.progiciels-bpi.ca/
BuildArch: noarch

BuildRequires: python-devel
BuildRequires: emacs
BuildRequires: /usr/bin/rst2html

%description
Pymacs is a powerful tool which, once started from Emacs, allows both-way
communication between Emacs Lisp and Python. Pymacs aims Python as an
extension language for Emacs rather than the other way around, and this
asymmetry is reflected in some design choices. Within Emacs Lisp code,
one may load and use Python modules. Python functions may themselves use
Emacs services, and handle Emacs Lisp objects kept in Emacs Lisp space.

%prep
%setup

%build
env CFLAGS="%optflags" make all

%install
python setup.py install --root=%buildroot --record=INSTALLED_FILES
emacs -batch -eval '(byte-compile-file "pymacs.el")'
mkdir -p %buildroot%_emacslispdir/pymacs
mv pymacs.elc %buildroot%_emacslispdir/pymacs

mkdir -p %buildroot/%_sysconfdir/emacs/site-start.d/
cat <<EOF > %buildroot/%_sysconfdir/emacs/site-start.d/pymacs.el
(autoload 'pymacs-apply "pymacs")
(autoload 'pymacs-call "pymacs")
(autoload 'pymacs-eval "pymacs" nil t)
(autoload 'pymacs-exec "pymacs" nil t)
(autoload 'pymacs-load "pymacs" nil t)
EOF

python pppp -C ppppconfig.py pymacs.rst.in
rst2html --input-encoding=UTF-8 pymacs.rst pymacs.html

%files -f INSTALLED_FILES
%_sysconfdir/emacs/site-start.d/pymacs.el
%python_sitelibdir/%name
%_emacslispdir/pymacs/
%doc TODO README THANKS pymacs.html

%changelog
