Name: SDL
Version: 1.2.14
Release: alt8

Summary: Simple DirectMedia Layer
License: LGPL
Group: System/Libraries

Url: http://www.libsdl.org/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: libGLU-devel libXext-devel libXrandr-devel libalsa-devel libpulseaudio-devel libusb-compat-devel
%ifarch %ix86 x86_64
BuildRequires: nasm
%endif

%description
This is the Simple DirectMedia Layer, a generic API that provides low level
access to audio, keyboard, mouse, and display framebuffer across multiple
platforms.

%package -n lib%name
Summary: Simple DirectMedia Layer
Group: System/Libraries
Provides: SDL

%description -n lib%name
This is the Simple DirectMedia Layer, a generic API that provides low level
access to audio, keyboard, mouse, and display framebuffer across multiple
platforms.

This package provides shared libraries required to run %name-based applications.

%package -n lib%name-devel
Summary: Development environment for Simple DirectMedia Layer
Group: Development/C
Requires: lib%name = %version-%release libGLU-devel

%description -n lib%name-devel
This is the Simple DirectMedia Layer, a generic API that provides low
level access to audio, keyboard, mouse, and display framebuffer across
multiple platforms.

This is the libraries, include files and other resources you can use
to develop %name applications.

%prep
%setup
%patch -p1

cat acinclude/* > aclocal.m4

%build
autoconf
%configure \
	--disable-nas \
	--disable-oss \
	--disable-esd \
	--disable-arts \
	--disable-alsa-shared \
	--disable-pulseaudio-shared \
	--disable-x11-shared \
	--disable-static
%make_build

%install
%makeinstall_std

%files -n lib%name
%doc BUGS CREDITS README README-%name.txt TODO WhatsNew
%_libdir/*.so.*

%files -n lib%name-devel
%doc docs.html docs/*html*
%_includedir/*
%_bindir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_datadir/aclocal/*
%_mandir/man?/*

# TODO: 1.2.15+

%changelog
