%def_with fcitx
%def_with ibus
%def_with nas
%def_with pulse

Name: SDL2
Version: 2.0.14
Release: alt4

Summary: Simple DirectMedia Layer
License: Zlib and MIT
Group: System/Libraries

Url: https://www.libsdl.org/
Packager: Nazarov Denis <nenderus@altlinux.org>

# https://www.libsdl.org/release/%name-%version.tar.gz
Source: %name-%version.tar

# RH: ptrdiff_t is not the same as khronos defines on 32bit arches
Patch0: %name-2.0.9-rh-khrplatform.patch

# http://bugzilla.libsdl.org/show_bug.cgi?id=5418
Patch1: SDL2-e2k.patch

BuildRequires: libXext-devel
BuildRequires: libdbus-devel

%{?_with_fcitx:BuildRequires: fcitx-devel}
BuildRequires: gcc-c++
BuildRequires: libGLES-devel
BuildRequires: libXScrnSaver-devel
BuildRequires: libXxf86vm-devel
BuildRequires: libalsa-devel
%{?_with_nas:BuildRequires: libaudio-devel}
BuildRequires: libesd-devel
%{?_with_ibus:BuildRequires: libibus-devel}
BuildRequires: libjack-devel
%{?_with_pulse:BuildRequires: libpulseaudio-devel}
BuildRequires: libsamplerate-devel
BuildRequires: libudev-devel
# Wayland support
BuildRequires: libxkbcommon-devel
BuildRequires: libwayland-client-devel
BuildRequires: libwayland-cursor-devel
BuildRequires: libwayland-egl-devel
BuildRequires: libwayland-server-devel
BuildRequires: wayland-devel
BuildRequires: wayland-protocols

%description
This is the Simple DirectMedia Layer, a generic API that provides low
level access to audio, keyboard, mouse, and display framebuffer across
multiple platforms.

%package -n lib%name
Summary: Simple DirectMedia Layer
Group: System/Libraries

%description -n lib%name
This is the Simple DirectMedia Layer, a generic API that provides low
level access to audio, keyboard, mouse, and display framebuffer across
multiple platforms.

%package -n lib%name-devel
Summary: Libraries, includes and more to develop SDL applications.
Group: Development/C
Conflicts: rpm-build < 4.0.4-alt100.96

%description -n lib%name-devel
This is the Simple DirectMedia Layer, a generic API that provides low
level access to audio, keyboard, mouse, and display framebuffer across
multiple platforms.

This is the libraries, include files and other resources you can use
to develop SDL applications.

%prep
%setup
%patch0 -p1
%ifarch %e2k
%patch1 -p1
%endif

%build
%add_optflags %(getconf LFS_CFLAGS)
%configure \
    --enable-video-vulkan \
    --enable-video-wayland \
    --disable-rpath \
    --disable-static
    
%make_build

%install
%makeinstall_std
rm %buildroot%_libdir/*.a
%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1

%files -n lib%name
%doc BUGS.txt COPYING.txt CREDITS.txt README*.txt WhatsNew.txt
%_libdir/lib%name-2.0.so.*

%files -n lib%name-devel
%_bindir/sdl2-config
%_includedir/%name/
%_libdir/lib%name.so
%_libdir/cmake/%name/
%_pkgconfigdir/sdl2.pc
%_aclocaldir/sdl2.m4

%changelog
