Name: SysVinit-usermode
Version: 1.5
Release: alt2
Serial: 1

Summary: Usermode bindings for reboot, halt and poweroff
License: GPL
Group: System/Configuration/Boot and Init
BuildArch: noarch
Packager: Dmitry V. Levin <ldv@altlinux.org>

Source0: reboot.pamd
Source1: reboot.apps

PreReq: coreutils
#Requires: SysVinit >= 0:2.82-alt2
Requires: SysVinit, sysvinit-utils

BuildPreReq: libpam0-devel

%description
This package contains usermode bindings for reboot, halt and poweroff.

%install
install -pD -m640 %_sourcedir/reboot.pamd \
	%buildroot%_sysconfdir/pam.d/reboot
install -pD -m640 %_sourcedir/reboot.apps \
	%buildroot%_sysconfdir/security/console.apps/reboot

mkdir -p %buildroot%_bindir
ln -s %_libexecdir/consolehelper/helper %buildroot%_bindir/reboot

for n in halt poweroff; do
	ln -s reboot "%buildroot%_bindir/$n"
	ln -s reboot "%buildroot%_sysconfdir/pam.d/$n"
	install -pD -m640 %_sourcedir/reboot.apps \
		"%buildroot%_sysconfdir/security/console.apps/$n"
	sed -i "s,reboot,$n," "%buildroot%_sysconfdir/security/console.apps/$n"
done

%triggerpostun -- %name < 1:1.4-alt3
f=%_sysconfdir/pam.d/reboot
if [ ! -f "$f" ]; then
	rm -f "$f"
	if [ -f "$f".rpmsave ]; then
		mv -f "$f".rpmsave "$f"
	elif [ -f "$f".rpmnew ]; then
		mv -f "$f".rpmnew "$f"
	fi
fi

%files
%_bindir/*
%config(noreplace) %_sysconfdir/pam.d/reboot
%_sysconfdir/pam.d/halt
%_sysconfdir/pam.d/poweroff
%config(missingok,noreplace) %_sysconfdir/security/console.apps/halt
%config(missingok,noreplace) %_sysconfdir/security/console.apps/reboot
%config(missingok,noreplace) %_sysconfdir/security/console.apps/poweroff

%changelog
