%define ver_major 3.32
%define xdg_name org.gnome.accerciser

Name: accerciser
Version: %ver_major.3
Release: alt1

Summary: Interactive Python accessibility explorer
Group: Accessibility
License: %bsd
Url: https://wiki.gnome.org/Apps/Accerciser

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

BuildArch: noarch

Requires: python3-module-%name = %version-%release

# use python3
AutoReqProv: nopython
%define __python %nil

BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildRequires: rpm-build-licenses rpm-build-gnome libappstream-glib-devel
BuildRequires: yelp-tools libgtk+3-devel python3-module-pygobject3-devel
BuildRequires: desktop-file-utils libat-spi2-core-devel

%description
An interactive Python accessibility explorer.

%add_python3_req_skip gi.repository.Gio

%package -n python3-module-%name
Summary: Python module for accerciser
Group: Development/Python
BuildArch: noarch
# The macro below is resolved into an empty string but confuses build process
#%_python_set_noarch

%description -n python3-module-%name
An interactive Python accessibility explorer.

This package contains Python module for accerciser.

%prep
%setup

%build
%configure
%make_build

%install
%makeinstall_std
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=X-Development-Accessibility \
        %buildroot%_desktopdir/%name.desktop

%find_lang --with-gnome %name

%files -f %name.lang
%doc AUTHORS README COPYING NEWS
%_bindir/*
%_datadir/%name
%_desktopdir/%name.desktop
%_man1dir/*
%_datadir/glib-2.0/schemas/*
%_datadir/icons/hicolor/*/*/%name.png
%_datadir/icons/hicolor/scalable/apps/accerciser.svg
%_datadir/icons/hicolor/symbolic/apps/accerciser-symbolic.svg
%_datadir/metainfo/accerciser.appdata.xml

%files -n python3-module-%name
%python3_sitelibdir/%name/

%changelog
