Group: Emulators
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/col /usr/bin/groff /usr/bin/valgrind bzlib-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           advancecomp
Version:        2.1
Release:        alt1_10
Summary:        Recompression utilities for png, mng, zip and gz files
License:        GPLv3
URL:            http://www.advancemame.it/
Source0:        https://github.com/amadvance/advancecomp/releases/download/v%{version}/advancecomp-%{version}.tar.gz

# CVE-2019-9210 advancecomp: integer overflow in png_compress in pngex.cc
Patch0:         advancecomp-CVE-2019-9210.patch

BuildRequires:  gcc gcc-c++
BuildRequires:  tofrodos
BuildRequires:  zlib-devel
BuildRequires:  dos2unix
Source44: import.info

%description
AdvanceCOMP is a set of recompression utilities for .PNG, .MNG and .ZIP files.
The main features are :
* Recompress ZIP, PNG and MNG files using the Deflate 7-Zip implementation.
* Recompress MNG files using Delta and Move optimization.

This package contains:
* advzip - Recompression and test utility for zip files
* advpng - Recompression utility for png files
* advmng - Recompression utility for mng files
* advdef - Recompression utility for deflate streams in png, mng and gz files

%prep
%setup -q
%patch0 -p1 -b .CVE-2019-9210

dos2unix -k doc/*.txt

%build
%configure
%make_build

%install
make install DESTDIR=%{buildroot}

%files
%doc --no-dereference COPYING
%doc AUTHORS HISTORY README
%doc doc/adv*.txt
%doc doc/authors.txt
%doc doc/history.txt
%doc doc/readme.txt
%{_bindir}/*
%{_mandir}/man1/*

%changelog
